/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.client;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Objects;

public class InputSourceFactory {
    protected final String m_name;
    protected final String m_baseIRI;
    protected final Object m_content;

    protected InputSourceFactory(String string, String string2, Object object) {
        this.m_name = string;
        this.m_content = object;
        this.m_baseIRI = string2;
    }

    public String getName() {
        return this.m_name;
    }

    public String getBaseIRI() {
        return this.m_baseIRI;
    }

    public Object getContent() {
        return this.m_content;
    }

    public static InputSourceFactory newInputSourceFactory(File file) {
        String string = file.toString();
        return new InputSourceFactory(string, string, file);
    }

    public static InputSourceFactory newInputSourceFactory(File file, String string, String string2) {
        String string3 = file.toString();
        return new InputSourceFactory(string3, string3, new FileEncryptionOptions(string, Objects.requireNonNull(string2, "The encryption key cannot be null.")));
    }

    public static InputSourceFactory newInputSourceFactory(URL uRL) {
        String string = uRL.toString();
        return new InputSourceFactory(string, string, URI.create(string));
    }

    public static InputSourceFactory newInputSourceFactory(URI uRI) {
        String string = uRI.toString();
        return new InputSourceFactory(string, string, uRI);
    }

    public static InputSourceFactory newInputSourceFactory(String string, String string2, String string3) {
        return new InputSourceFactory(string, Objects.requireNonNull(string2, "The base IRI cannot be null."), string3);
    }

    public static InputSourceFactory newInputSourceFactory(String string, String string2, InputStream inputStream) {
        return new InputSourceFactory(string, Objects.requireNonNull(string2, "The base IRI cannot be null."), inputStream);
    }

    protected static class FileEncryptionOptions {
        protected final String m_algorithm;
        protected final String m_key;

        public FileEncryptionOptions(String string, String string2) {
            this.m_algorithm = string;
            this.m_key = string2;
        }

        public String getAlgorithm() {
            return this.m_algorithm;
        }

        public String getKey() {
            return this.m_key;
        }
    }
}

