/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.client;

import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxResourceValue;
import tech.oxfordsemantic.jrdfox.logic.Datatype;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;

public interface ResourceValue {
    public static final ResourceValue UNDEF = ResourceValue.create("UNDEF", Datatype.INVALID_DATATYPE);

    public boolean isValid();

    public String getLexicalForm();

    public Datatype getDatatype();

    public Resource toResource();

    public String toString();

    public String toString(Prefixes var1);

    public static void appendString(Consumer<String> consumer, String string, int n) {
        consumer.accept("\"");
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    consumer.accept("\\n");
                    continue block5;
                }
                case '\r': {
                    consumer.accept("\\r");
                    continue block5;
                }
                case '\"': 
                case '\\': {
                    consumer.accept("\\");
                }
                default: {
                    consumer.accept(Character.toString(c));
                }
            }
        }
        consumer.accept("\"");
    }

    public static void toString(Prefixes prefixes, Consumer<String> consumer, String string, Datatype datatype) {
        switch (datatype) {
            case INVALID_DATATYPE: {
                consumer.accept("UNDEF");
                break;
            }
            case IRI_REFERENCE: {
                prefixes.encodeIRI((CharSequence)string, consumer);
                break;
            }
            case BLANK_NODE: {
                consumer.accept("_:");
                consumer.accept(string);
                break;
            }
            case XSD_STRING: {
                ResourceValue.appendString(consumer, string, string.length());
                break;
            }
            case RDF_PLAIN_LITERAL: {
                int n = string.lastIndexOf(64);
                int n2 = string.length();
                if (n == -1) {
                    ResourceValue.appendString(consumer, string, n2);
                    break;
                }
                ResourceValue.appendString(consumer, string, n);
                if (n + 1 >= n2) break;
                for (int i = n; i < n2; ++i) {
                    consumer.accept(Character.toString(string.charAt(i)));
                }
                break;
            }
            case XSD_INTEGER: {
                consumer.accept(string);
                break;
            }
            case XSD_BOOLEAN: {
                consumer.accept(string);
                break;
            }
            default: {
                ResourceValue.appendString(consumer, string, string.length());
                consumer.accept("^^");
                prefixes.encodeIRI((CharSequence)datatype.getIRI(), consumer);
            }
        }
    }

    public static ResourceValue create(String string, Datatype datatype) {
        return new JRDFoxResourceValue(string, datatype);
    }
}

