/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.formats.internal;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.client.ResourceValue;
import tech.oxfordsemantic.jrdfox.exceptions.ParsingException;
import tech.oxfordsemantic.jrdfox.formats.internal.CommonTokenizer;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxResourceValue;
import tech.oxfordsemantic.jrdfox.logic.Datatype;
import tech.oxfordsemantic.jrdfox.logic.expression.BlankNode;
import tech.oxfordsemantic.jrdfox.logic.expression.ExistenceExpression;
import tech.oxfordsemantic.jrdfox.logic.expression.Expression;
import tech.oxfordsemantic.jrdfox.logic.expression.FunctionCall;
import tech.oxfordsemantic.jrdfox.logic.expression.IRI;
import tech.oxfordsemantic.jrdfox.logic.expression.Literal;
import tech.oxfordsemantic.jrdfox.logic.expression.Term;
import tech.oxfordsemantic.jrdfox.logic.expression.Variable;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.GroupGraphPattern;

public abstract class AbstractParser {
    protected CommonTokenizer m_tokenizer;
    protected Prefixes m_prefixes;
    protected URI m_baseIRI;

    protected void nextToken() throws ParsingException, IOException {
        this.m_tokenizer.nextToken();
        if (this.m_tokenizer.isErrorToken()) {
            throw new ParsingException("Invalid token.");
        }
    }

    protected void recoverFromErrorBySkippingAfterNext(char c, char c2) throws IOException {
        do {
            this.m_tokenizer.recover();
            while (this.m_tokenizer.isGood() && (!this.m_tokenizer.isNonSymbol() || !this.m_tokenizer.tokenEqualsNoType(c) && !this.m_tokenizer.tokenEqualsNoType(c2))) {
                this.m_tokenizer.nextToken();
            }
            this.m_tokenizer.nextToken();
        } while (this.m_tokenizer.isErrorToken());
    }

    protected void parsePrefixMapping() throws ParsingException, IOException {
        this.nextToken();
        if (!this.m_tokenizer.is_PNAME_NS()) {
            throw new ParsingException("Prefix name expected.");
        }
        String string = this.m_tokenizer.getToken();
        this.nextToken();
        if (!this.m_tokenizer.isQuotedIRI()) {
            throw new ParsingException("Prefix IRI of the form <IRI> expected.");
        }
        String string2 = this.m_tokenizer.getToken();
        this.nextToken();
        this.prefixMappingParsed(string, string2);
        if (this.m_prefixes.declarePrefix(string, string2) == Prefixes.DeclareResult.INVALID_PREFIX_NAME) {
            throw new ParsingException("Could not declare prefix '" + string + "' as IRI '<" + string2 + ">'.");
        }
    }

    protected boolean isIRI() {
        switch (this.m_tokenizer.getTokenType()) {
            case QUOTED_IRI: 
            case PNAME_LN: 
            case PNAME_NS: {
                return true;
            }
            case SYMBOL: {
                return this.m_tokenizer.tokenEqualsNoType("a");
            }
        }
        return false;
    }

    protected Variable parseVariable() throws ParsingException, IOException {
        if (!this.m_tokenizer.isVariable()) {
            throw new ParsingException("Variable expected.");
        }
        String string = this.m_tokenizer.getToken(1);
        this.nextToken();
        return Variable.create(string);
    }

    protected boolean isTerm() {
        return this.m_tokenizer.isVariable() || this.isResource();
    }

    protected Term parseTerm() throws ParsingException, IOException {
        if (this.m_tokenizer.isVariable()) {
            return this.parseVariable();
        }
        ResourceValue resourceValue = this.parseResource();
        switch (resourceValue.getDatatype()) {
            case IRI_REFERENCE: {
                return IRI.create(resourceValue.getLexicalForm());
            }
            case BLANK_NODE: {
                return BlankNode.create(resourceValue.getLexicalForm());
            }
        }
        return Literal.create(resourceValue.getLexicalForm(), resourceValue.getDatatype());
    }

    protected String resolveIRI(String string) throws ParsingException {
        int n = string.length();
        if (string.length() > 1 && Character.isLetter(string.charAt(0))) {
            for (int i = 1; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ':') {
                    if (i != n - 1 && string.charAt(i + 1) != '?' && string.charAt(i + 1) != '#') break;
                    return string;
                }
                if (!Character.isLetterOrDigit(c) && c != '+' && c != '-' && c != '.') break;
            }
        }
        return this.m_baseIRI.resolve(string).toString();
    }

    protected String parseIRI() throws ParsingException, IOException {
        if (this.m_tokenizer.isQuotedIRI()) {
            String string = this.m_tokenizer.getToken();
            this.nextToken();
            return this.resolveIRI(string);
        }
        if (this.m_tokenizer.is_PNAME_LN() || this.m_tokenizer.is_PNAME_NS()) {
            String string = this.m_tokenizer.getToken();
            this.nextToken();
            StringBuilder stringBuilder = new StringBuilder();
            Prefixes.DecodeResult decodeResult = this.m_prefixes.decodeIRI((CharSequence)string, stringBuilder);
            if (decodeResult == Prefixes.DecodeResult.NO_PREFIX_NAME) {
                throw new ParsingException("Token '" + string + "' does not contain a prefix name.");
            }
            if (decodeResult == Prefixes.DecodeResult.PREFIX_NAME_NOT_BOUND) {
                throw new ParsingException("The prefix name in the local IRI '" + string + "' has not been bound.");
            }
            string = stringBuilder.toString();
            return this.resolveIRI(string);
        }
        return null;
    }

    protected boolean isResource() {
        return this.m_tokenizer.isQuotedIRI() || this.m_tokenizer.is_PNAME_LN() || this.m_tokenizer.is_PNAME_NS() || this.m_tokenizer.symbolTokenEquals("a") || this.m_tokenizer.symbolLowerCaseTokenEquals("true") || this.m_tokenizer.symbolLowerCaseTokenEquals("false") || this.m_tokenizer.nonSymbolTokenEquals('-') || this.m_tokenizer.nonSymbolTokenEquals('+') || this.m_tokenizer.isInteger() || this.m_tokenizer.isIntegerWithExponent() || this.m_tokenizer.isDecimal() || this.m_tokenizer.isDecimalWithExponent() || this.m_tokenizer.isQuotedString() || this.m_tokenizer.isBlankNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ResourceValue parseResource() throws ParsingException, IOException {
        Object object = this.parseIRI();
        Datatype datatype = null;
        if (object != null) {
            datatype = Datatype.IRI_REFERENCE;
            return new JRDFoxResourceValue((String)object, datatype);
        } else if (this.m_tokenizer.symbolTokenEquals("a")) {
            object = IRI.RDF_TYPE.getIRI();
            datatype = Datatype.IRI_REFERENCE;
            this.nextToken();
            return new JRDFoxResourceValue((String)object, datatype);
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("true") || this.m_tokenizer.symbolLowerCaseTokenEquals("false")) {
            object = this.m_tokenizer.getToken();
            datatype = Datatype.XSD_BOOLEAN;
            this.nextToken();
            return new JRDFoxResourceValue((String)object, datatype);
        } else if (this.m_tokenizer.nonSymbolTokenEquals('-') || this.m_tokenizer.nonSymbolTokenEquals('+')) {
            char c = this.m_tokenizer.getToken().charAt(0);
            this.nextToken();
            if (!this.m_tokenizer.isInteger() && !this.m_tokenizer.isIntegerWithExponent() && !this.m_tokenizer.isDecimal() && !this.m_tokenizer.isDecimalWithExponent()) throw new ParsingException("Number expected after - or +.");
            object = c + this.m_tokenizer.getToken();
            datatype = this.m_tokenizer.isInteger() ? Datatype.XSD_INTEGER : (this.m_tokenizer.isDecimal() ? Datatype.XSD_DECIMAL : Datatype.XSD_DOUBLE);
            this.nextToken();
            return new JRDFoxResourceValue((String)object, datatype);
        } else if (this.m_tokenizer.isInteger() || this.m_tokenizer.isIntegerWithExponent() || this.m_tokenizer.isDecimal() || this.m_tokenizer.isDecimalWithExponent()) {
            object = this.m_tokenizer.getToken();
            datatype = this.m_tokenizer.isInteger() ? Datatype.XSD_INTEGER : (this.m_tokenizer.isDecimal() ? Datatype.XSD_DECIMAL : Datatype.XSD_DOUBLE);
            this.nextToken();
            return new JRDFoxResourceValue((String)object, datatype);
        } else if (this.m_tokenizer.isQuotedString()) {
            object = this.m_tokenizer.getToken();
            this.nextToken();
            if (this.m_tokenizer.isLanguageTag()) {
                this.m_tokenizer.appendToken(new StringBuilder((String)object));
                this.nextToken();
                datatype = Datatype.RDF_PLAIN_LITERAL;
                return new JRDFoxResourceValue((String)object, datatype);
            } else if (this.m_tokenizer.nonSymbolTokenEquals("^^")) {
                this.nextToken();
                String string = this.parseIRI();
                if (string == null) {
                    throw new ParsingException("Datatype IRI of a literal is missing.");
                }
                datatype = Datatype.value(string);
                return new JRDFoxResourceValue((String)object, datatype);
            } else {
                datatype = Datatype.XSD_STRING;
            }
            return new JRDFoxResourceValue((String)object, datatype);
        } else {
            if (!this.m_tokenizer.isBlankNode()) throw new ParsingException("Resource expected.");
            object = this.m_tokenizer.getToken(2);
            datatype = Datatype.BLANK_NODE;
            this.nextToken();
        }
        return new JRDFoxResourceValue((String)object, datatype);
    }

    protected Expression parseConstraintExpression() throws ParsingException, IOException {
        if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
            this.nextToken();
            Expression expression = this.parseConditionalOrExpression();
            if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                throw new ParsingException("Unbalanced parentheses in a built-in expression.");
            }
            this.nextToken();
            return expression;
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("not")) {
            this.nextToken();
            return this.parseExistenceExpression(false);
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("exists")) {
            return this.parseExistenceExpression(true);
        }
        return this.parseFunctionCallExpression();
    }

    protected Expression parseConditionalOrExpression() throws ParsingException, IOException {
        Expression expression = this.parseConditionalAndExpression();
        if (this.m_tokenizer.nonSymbolTokenEquals("||")) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            arrayList.add(expression);
            while (this.m_tokenizer.nonSymbolTokenEquals("||")) {
                this.nextToken();
                arrayList.add(this.parseConditionalAndExpression());
            }
            return FunctionCall.logicalOr(arrayList);
        }
        return expression;
    }

    protected Expression parseConditionalAndExpression() throws ParsingException, IOException {
        Expression expression = this.parseRelationalExpression();
        if (this.m_tokenizer.nonSymbolTokenEquals("&&")) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            arrayList.add(expression);
            while (this.m_tokenizer.nonSymbolTokenEquals("&&")) {
                this.nextToken();
                arrayList.add(this.parseRelationalExpression());
            }
            return FunctionCall.logicalAnd(arrayList);
        }
        return expression;
    }

    protected Expression parseRelationalExpression() throws ParsingException, IOException {
        Expression expression = this.parseAdditiveExpression();
        String string = null;
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("in") || this.m_tokenizer.symbolLowerCaseTokenEquals("not")) {
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("not")) {
                this.nextToken();
                if (!this.m_tokenizer.symbolLowerCaseTokenEquals("in")) {
                    throw new ParsingException("Expected 'IN' after 'NOT'.");
                }
                string = "internal:not-in";
            } else {
                string = "internal:in";
            }
            this.nextToken();
            if (!this.m_tokenizer.nonSymbolTokenEquals('(')) {
                throw new ParsingException("Expected '('.");
            }
            this.nextToken();
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            arrayList.add(expression);
            if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                arrayList.add(this.parseConditionalOrExpression());
                while (this.m_tokenizer.nonSymbolTokenEquals(',')) {
                    this.nextToken();
                    arrayList.add(this.parseConditionalOrExpression());
                }
                if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                    throw new ParsingException("Expression list should be terminated by ')'.");
                }
            }
            this.nextToken();
            return FunctionCall.create(string, arrayList);
        }
        if (this.m_tokenizer.nonSymbolTokenEquals('=')) {
            string = "internal:equal";
        } else if (this.m_tokenizer.nonSymbolTokenEquals("!=")) {
            string = "internal:not-equal";
        } else if (this.m_tokenizer.nonSymbolTokenEquals('<')) {
            string = "internal:less-than";
        } else if (this.m_tokenizer.nonSymbolTokenEquals("<=")) {
            string = "internal:less-equal-than";
        } else if (this.m_tokenizer.nonSymbolTokenEquals('>')) {
            string = "internal:greater-than";
        } else if (this.m_tokenizer.nonSymbolTokenEquals(">=")) {
            string = "internal:greater-equal-than";
        } else {
            return expression;
        }
        this.nextToken();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(expression);
        arrayList.add(this.parseAdditiveExpression());
        return FunctionCall.create(string, arrayList);
    }

    protected Expression parseAdditiveExpression() throws ParsingException, IOException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(this.parseMultiplicativeExpression());
        while (true) {
            Expression expression;
            if (this.m_tokenizer.nonSymbolTokenEquals('+')) {
                this.nextToken();
                arrayList.add(this.parseMultiplicativeExpression());
                continue;
            }
            if (arrayList.size() > 1) {
                expression = FunctionCall.add(arrayList);
                arrayList.clear();
                arrayList.add(expression);
            }
            while (this.m_tokenizer.nonSymbolTokenEquals('-')) {
                this.nextToken();
                expression = this.parseMultiplicativeExpression();
                assert (arrayList.size() == 1);
                FunctionCall functionCall = FunctionCall.subtract((Expression)arrayList.get(0), expression);
                arrayList.clear();
                arrayList.add(functionCall);
            }
            if (!this.m_tokenizer.nonSymbolTokenEquals('+')) break;
        }
        assert (arrayList.size() == 1);
        return (Expression)arrayList.get(0);
    }

    protected String parseMultiplicativeExpressionFunction() {
        if (this.m_tokenizer.nonSymbolTokenEquals('/')) {
            return "internal:divide";
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("idiv")) {
            return "internal:idiv";
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("mod")) {
            return "internal:mod";
        }
        return null;
    }

    protected Expression parseMultiplicativeExpression() throws ParsingException, IOException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(this.parseUnaryExpression());
        while (true) {
            Object object;
            if (this.m_tokenizer.nonSymbolTokenEquals('*')) {
                this.nextToken();
                arrayList.add(this.parseUnaryExpression());
                continue;
            }
            if (arrayList.size() > 1) {
                object = FunctionCall.create("internal:multiply", arrayList);
                arrayList.clear();
                arrayList.add((Expression)object);
            }
            while ((object = this.parseMultiplicativeExpressionFunction()) != null) {
                this.nextToken();
                arrayList.add(this.parseUnaryExpression());
                FunctionCall functionCall = FunctionCall.create((String)object, arrayList);
                arrayList.clear();
                arrayList.add(functionCall);
            }
            if (!this.m_tokenizer.nonSymbolTokenEquals('*')) break;
        }
        assert (arrayList.size() == 1);
        return (Expression)arrayList.get(0);
    }

    protected Expression parseNegatedNumber(Datatype datatype) throws ParsingException, IOException {
        String string = "-" + this.m_tokenizer.getToken();
        JRDFoxResourceValue jRDFoxResourceValue = new JRDFoxResourceValue(string, datatype);
        this.nextToken();
        return Literal.create(jRDFoxResourceValue.getLexicalForm(), jRDFoxResourceValue.getDatatype());
    }

    protected Expression parseUnaryExpression() throws ParsingException, IOException {
        String string = null;
        if (this.m_tokenizer.nonSymbolTokenEquals('!')) {
            this.nextToken();
            string = "internal:logical-not";
        } else if (this.m_tokenizer.nonSymbolTokenEquals('+')) {
            this.nextToken();
            if (this.m_tokenizer.isInteger() || this.m_tokenizer.isIntegerWithExponent() || this.m_tokenizer.isDecimal() || this.m_tokenizer.isDecimalWithExponent()) {
                return this.parseTerm();
            }
            string = "internal:numeric-unary-plus";
        } else if (this.m_tokenizer.nonSymbolTokenEquals('-')) {
            this.nextToken();
            switch (this.m_tokenizer.getTokenType()) {
                case INTEGER: {
                    return this.parseNegatedNumber(Datatype.XSD_INTEGER);
                }
                case DECIMAL: {
                    return this.parseNegatedNumber(Datatype.XSD_DECIMAL);
                }
                case INTEGER_WITH_EXPONENT: 
                case DECIMAL_WITH_EXPONENT: {
                    return this.parseNegatedNumber(Datatype.XSD_DOUBLE);
                }
            }
            string = "internal:numeric-unary-minus";
        }
        Expression expression = this.parsePrimaryExpression();
        if (string != null) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            arrayList.add(expression);
            expression = FunctionCall.create(string, arrayList);
        }
        return expression;
    }

    protected FunctionCall parseFunctionCallExpression() throws ParsingException, IOException {
        String string;
        if (this.m_tokenizer.isSymbol()) {
            string = this.m_tokenizer.getToken();
            this.m_tokenizer.nextToken();
        } else {
            string = this.parseIRI();
            if (string == null) {
                throw new ParsingException("Function name expected.");
            }
        }
        return this.parseFunctionCallExpression(string);
    }

    protected FunctionCall parseFunctionCallExpression(String string) throws ParsingException, IOException {
        Object object;
        boolean bl;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (!this.m_tokenizer.nonSymbolTokenEquals('(')) {
            throw new ParsingException("Expected '('.");
        }
        this.nextToken();
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("distinct")) {
            this.nextToken();
            bl = true;
        } else {
            bl = false;
        }
        if (this.m_tokenizer.nonSymbolTokenEquals('*')) {
            this.nextToken();
            arrayList.add(IRI.create("internal:argument-*"));
        } else if (!this.m_tokenizer.nonSymbolTokenEquals(')') && !this.m_tokenizer.nonSymbolTokenEquals(';')) {
            arrayList.add(this.parseConditionalOrExpression());
            while (this.m_tokenizer.nonSymbolTokenEquals(',')) {
                this.nextToken();
                arrayList.add(this.parseConditionalOrExpression());
            }
        }
        ArrayList<FunctionCall.ScalarValue> arrayList2 = new ArrayList<FunctionCall.ScalarValue>();
        while (this.m_tokenizer.nonSymbolTokenEquals(';')) {
            this.nextToken();
            if (!this.m_tokenizer.isSymbol()) {
                throw new ParsingException("The name of the scalar value of aggregate function is incorrect.");
            }
            object = this.m_tokenizer.getToken();
            this.nextToken();
            if (!this.m_tokenizer.nonSymbolTokenEquals('=')) {
                throw new ParsingException("Scalar value name must be followed by '='.");
            }
            this.nextToken();
            if (!this.m_tokenizer.isQuotedString()) {
                throw new ParsingException("Scalar value must be a string enclosed in quotes.");
            }
            String string2 = this.m_tokenizer.getToken();
            arrayList2.add(new FunctionCall.ScalarValue((String)object, string2));
            this.nextToken();
        }
        if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
            throw new ParsingException("Expression list should be terminated by ')'.");
        }
        this.nextToken();
        if (arrayList.size() == 1 && (string.equals("IRI") || string.equals("URI"))) {
            object = new JRDFoxResourceValue(this.m_baseIRI.toString(), Datatype.IRI_REFERENCE);
            arrayList.add(Literal.create(object.getLexicalForm(), object.getDatatype()));
        }
        return FunctionCall.create(string, bl, arrayList2, arrayList);
    }

    protected Expression parsePrimaryExpression() throws ParsingException, IOException {
        if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
            this.nextToken();
            Expression expression = this.parseConditionalOrExpression();
            if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                throw new ParsingException("Unbalanced parentheses in a built-in expression.");
            }
            this.nextToken();
            return expression;
        }
        if (this.m_tokenizer.isVariable()) {
            return this.parseVariable();
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("not")) {
            this.nextToken();
            return this.parseExistenceExpression(false);
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("exists")) {
            return this.parseExistenceExpression(true);
        }
        if (this.m_tokenizer.isSymbol()) {
            if (this.m_tokenizer.tokenEqualsNoType('a')) {
                this.nextToken();
                return IRI.RDF_TYPE;
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("true")) {
                this.nextToken();
                return Literal.create("true", Datatype.XSD_BOOLEAN);
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("false")) {
                this.nextToken();
                return Literal.create("false", Datatype.XSD_BOOLEAN);
            }
            String string = this.m_tokenizer.getToken();
            this.nextToken();
            return this.parseFunctionCallExpression(string);
        }
        ResourceValue resourceValue = this.parseResource();
        switch (resourceValue.getDatatype()) {
            case IRI_REFERENCE: {
                if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
                    return this.parseFunctionCallExpression(resourceValue.getLexicalForm());
                }
                return IRI.create(resourceValue.getLexicalForm());
            }
            case BLANK_NODE: {
                return BlankNode.create(resourceValue.getLexicalForm());
            }
        }
        return Literal.create(resourceValue.getLexicalForm(), resourceValue.getDatatype());
    }

    protected ExistenceExpression parseExistenceExpression(boolean bl) throws ParsingException, IOException {
        if (!this.m_tokenizer.symbolLowerCaseTokenEquals("exists")) {
            throw new ParsingException("'EXISTS' expected.");
        }
        this.nextToken();
        GroupGraphPattern groupGraphPattern = this.parseExistenceExpressionArgument();
        return ExistenceExpression.create(bl, groupGraphPattern);
    }

    protected abstract GroupGraphPattern parseExistenceExpressionArgument() throws ParsingException, IOException;

    protected abstract void prefixMappingParsed(String var1, String var2) throws ParsingException, IOException;
}

