/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.impl;

import java.util.Arrays;
import tech.oxfordsemantic.jrdfox.client.ResourceValue;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxResourceValue;
import tech.oxfordsemantic.jrdfox.logic.Datatype;
import tech.oxfordsemantic.jrdfox.logic.expression.BlankNode;
import tech.oxfordsemantic.jrdfox.logic.expression.IRI;
import tech.oxfordsemantic.jrdfox.logic.expression.Literal;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;

public class JRDFoxResourceValueCache {
    protected static final long FIRST_USER_RESOURCE_ID = JRDFoxResourceValueCache.nGetFirstUserResourceID();
    protected static final ResourceValue[] s_wellKnownResourceValues = new ResourceValue[(int)FIRST_USER_RESOURCE_ID];
    protected final int m_lexicalFormsBufferSize;
    protected final char[] m_lexicalFormsBuffer;
    protected final long[] m_singleResourceID;
    protected final ResourceValue[] m_singleResourceValue;
    protected final int m_cacheBucketsSizeMinusOne;
    protected final int m_cacheCapacity;
    protected final CachedResourceValue[] m_cacheBuckets;
    protected int m_cacheSize;
    protected long[] m_jniCommunicationBuffer;
    protected CachedResourceValue[] m_resolvedResourceValues;
    protected long m_dictionaryVersion;

    protected static native long nGetFirstUserResourceID();

    protected static native void nGetWellKnownResources(String[] var0, short[] var1) throws JRDFoxException;

    protected static native int nResolveResourceValues(long var0, long[] var2, int var3, int var4, char[] var5, int var6) throws JRDFoxException;

    protected JRDFoxResourceValueCache() throws JRDFoxException {
        this.m_lexicalFormsBufferSize = 131072;
        this.m_lexicalFormsBuffer = new char[this.m_lexicalFormsBufferSize];
        this.m_singleResourceID = new long[1];
        this.m_singleResourceValue = new ResourceValue[1];
        int n = 4096;
        this.m_cacheBucketsSizeMinusOne = n - 1;
        this.m_cacheCapacity = (int)((double)n * 0.7);
        this.m_cacheBuckets = new CachedResourceValue[n];
        this.m_cacheSize = 0;
        this.m_jniCommunicationBuffer = new long[10];
        this.m_resolvedResourceValues = new CachedResourceValue[10];
        this.m_dictionaryVersion = -1L;
    }

    protected final void clearCache() {
        Arrays.fill(this.m_cacheBuckets, null);
        this.m_cacheSize = 0;
    }

    protected final void setVersion(long l) {
        if (l != this.m_dictionaryVersion) {
            this.clearCache();
            this.m_dictionaryVersion = l;
        }
    }

    public final void getResourceValuesUseCache(long l, long[] lArray, int n, ResourceValue[] resourceValueArray, long l2) throws JRDFoxException {
        this.setVersion(l2);
        if (this.m_jniCommunicationBuffer.length < n) {
            this.m_jniCommunicationBuffer = new long[n];
            this.m_resolvedResourceValues = new CachedResourceValue[n];
        }
        Datatype[] datatypeArray = Datatype.values();
        try {
            int n2;
            int n3 = 0;
            block2: for (int i = 0; i < n; ++i) {
                long l3 = lArray[i];
                if (l3 < 0L) {
                    this.m_resolvedResourceValues[n3] = new CachedResourceValue(l3);
                    resourceValueArray[i] = this.m_resolvedResourceValues[n3];
                    this.m_jniCommunicationBuffer[n3] = l3;
                    ++n3;
                    continue;
                }
                if (l3 < FIRST_USER_RESOURCE_ID) {
                    resourceValueArray[i] = s_wellKnownResourceValues[(int)l3];
                    continue;
                }
                n2 = (int)(l3 * 2654435761L) & this.m_cacheBucketsSizeMinusOne;
                while (true) {
                    CachedResourceValue cachedResourceValue;
                    if ((cachedResourceValue = this.m_cacheBuckets[n2]) == null) {
                        this.m_cacheBuckets[n2] = this.m_resolvedResourceValues[n3] = (cachedResourceValue = new CachedResourceValue(l3));
                        resourceValueArray[i] = this.m_resolvedResourceValues[n3];
                        this.m_jniCommunicationBuffer[n3] = l3;
                        ++n3;
                        ++this.m_cacheSize;
                        if (this.m_cacheSize != this.m_cacheCapacity) continue block2;
                        this.clearCache();
                        continue block2;
                    }
                    if (cachedResourceValue.m_resourceID == l3) {
                        resourceValueArray[i] = cachedResourceValue;
                        continue block2;
                    }
                    if (n2 == this.m_cacheBucketsSizeMinusOne) {
                        n2 = 0;
                        continue;
                    }
                    ++n2;
                }
            }
            char[] cArray = this.m_lexicalFormsBuffer;
            int n4 = this.m_lexicalFormsBufferSize;
            int n5 = 0;
            while (n5 != n3) {
                n2 = JRDFoxResourceValueCache.nResolveResourceValues(l, this.m_jniCommunicationBuffer, n5, n3, cArray, n4);
                if (n2 == n5) {
                    cArray = new char[n4 *= 2];
                    continue;
                }
                int n6 = 0;
                for (int i = n5; i < n2; ++i) {
                    CachedResourceValue cachedResourceValue = this.m_resolvedResourceValues[i];
                    long l4 = this.m_jniCommunicationBuffer[i];
                    int n7 = (int)l4 >>> 8;
                    cachedResourceValue.m_lexicalForm = new String(cArray, n6, n7);
                    cachedResourceValue.m_datatype = datatypeArray[(int)(l4 & 0xFFL)];
                    n6 += n7;
                }
                n5 = n2;
            }
        }
        catch (Throwable throwable) {
            this.clearCache();
            throw throwable;
        }
    }

    public final void getResourceValuesNoCache(long l, long[] lArray, int n, ResourceValue[] resourceValueArray) throws JRDFoxException {
        if (this.m_jniCommunicationBuffer.length < n) {
            this.m_jniCommunicationBuffer = new long[n];
            this.m_resolvedResourceValues = new CachedResourceValue[n];
        }
        Datatype[] datatypeArray = Datatype.values();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[i];
            if (0L <= l2 && l2 < FIRST_USER_RESOURCE_ID) {
                resourceValueArray[i] = s_wellKnownResourceValues[(int)l2];
                continue;
            }
            this.m_resolvedResourceValues[n2] = new CachedResourceValue(l2);
            resourceValueArray[i] = this.m_resolvedResourceValues[n2];
            this.m_jniCommunicationBuffer[n2] = l2;
            ++n2;
        }
        char[] cArray = this.m_lexicalFormsBuffer;
        int n3 = this.m_lexicalFormsBufferSize;
        int n4 = 0;
        while (n2 != n4) {
            int n5 = JRDFoxResourceValueCache.nResolveResourceValues(l, this.m_jniCommunicationBuffer, n4, n2, cArray, n3);
            if (n5 == n4) {
                cArray = new char[n3 *= 2];
                continue;
            }
            int n6 = 0;
            for (int i = n4; i < n5; ++i) {
                CachedResourceValue cachedResourceValue = this.m_resolvedResourceValues[i];
                long l3 = this.m_jniCommunicationBuffer[i];
                int n7 = (int)l3 >>> 8;
                cachedResourceValue.m_lexicalForm = new String(cArray, n6, n7);
                cachedResourceValue.m_datatype = datatypeArray[(int)(l3 & 0xFFL)];
                n6 += n7;
            }
            n4 = n5;
        }
    }

    static {
        try {
            Datatype[] datatypeArray = Datatype.values();
            String[] stringArray = new String[(int)FIRST_USER_RESOURCE_ID];
            short[] sArray = new short[(int)FIRST_USER_RESOURCE_ID];
            JRDFoxResourceValueCache.nGetWellKnownResources(stringArray, sArray);
            int n = 0;
            while ((long)n < FIRST_USER_RESOURCE_ID) {
                String string = stringArray[n];
                short s = sArray[n];
                JRDFoxResourceValueCache.s_wellKnownResourceValues[n] = new JRDFoxResourceValue(string, datatypeArray[s]);
                ++n;
            }
        }
        catch (JRDFoxException jRDFoxException) {
            throw new RuntimeException("There was an error in retrieving well-known resources for the java resource value cache.", jRDFoxException);
        }
    }

    public static class CachedResourceValue
    extends JRDFoxResourceValue {
        protected final long m_resourceID;
        protected Resource m_resource;

        public CachedResourceValue(long l) {
            this.m_resourceID = l;
            this.m_resource = null;
        }

        @Override
        public Resource toResource() {
            if (this.m_resource == null && this.m_datatype != null) {
                switch (this.m_datatype) {
                    case IRI_REFERENCE: {
                        this.m_resource = IRI.create(this.m_lexicalForm);
                        break;
                    }
                    case BLANK_NODE: {
                        this.m_resource = BlankNode.create(this.m_lexicalForm);
                        break;
                    }
                    default: {
                        this.m_resource = Literal.create(this.m_lexicalForm, this.m_datatype);
                    }
                }
            }
            return this.m_resource;
        }
    }
}

