/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.sparql.statement;

import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.LogicVisitor;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Update;
import tech.oxfordsemantic.jrdfox.util.InterningManager;
import tech.oxfordsemantic.jrdfox.util.Primes;

public class GraphUpdate
extends Update {
    protected final GraphUpdateType m_graphUpdateType;
    protected final boolean m_silent;
    protected final GraphSpecification m_sourceGraphSpecification;
    protected final Resource m_sourceGraph;
    protected final GraphSpecification m_targetGraphSpecification;
    protected final Resource m_targetGraph;
    private static final long serialVersionUID = -6709967746547893013L;
    protected static final int s_classHashCodeTimes31 = 31 * GraphUpdate.class.hashCode();
    protected static InterningManager.Creator s_creator = new InterningManager.Creator(){

        @Override
        public InterningManager.InternedObject create(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
            return new GraphUpdate((GraphUpdateType)((Object)object), (Boolean)object2, (GraphSpecification)((Object)object3), (Resource)object4, (GraphSpecification)((Object)object5), (Resource)object6);
        }
    };

    protected GraphUpdate(GraphUpdateType graphUpdateType, boolean bl, GraphSpecification graphSpecification, Resource resource, GraphSpecification graphSpecification2, Resource resource2) {
        this.m_graphUpdateType = graphUpdateType;
        this.m_silent = bl;
        this.m_sourceGraphSpecification = graphSpecification;
        this.m_sourceGraph = resource;
        this.m_targetGraphSpecification = graphSpecification2;
        this.m_targetGraph = resource2;
    }

    public GraphUpdateType getGraphUpdateType() {
        return this.m_graphUpdateType;
    }

    public boolean getSilent() {
        return this.m_silent;
    }

    public GraphSpecification getSourceGraphSpecification() {
        return this.m_sourceGraphSpecification;
    }

    public Resource getSourceGraph() {
        return this.m_sourceGraph;
    }

    public GraphSpecification getTargetGraphSpecification() {
        return this.m_targetGraphSpecification;
    }

    public Resource getTargetGraph() {
        return this.m_targetGraph;
    }

    @Override
    public <E> E accept(LogicVisitor<E> logicVisitor) {
        return logicVisitor.visit(this);
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        switch (this.m_graphUpdateType) {
            case ADD: {
                consumer.accept("ADD ");
                break;
            }
            case CLEAR: {
                consumer.accept("CLEAR ");
                break;
            }
            case COPY: {
                consumer.accept("COPY ");
                break;
            }
            case CREATE: {
                consumer.accept("CREATE ");
                break;
            }
            case DROP: {
                consumer.accept("DROP ");
                break;
            }
            case MOVE: {
                consumer.accept("MOVE ");
            }
        }
        if (this.m_silent) {
            consumer.accept("SILENT ");
        }
        switch (this.m_graphUpdateType) {
            case ADD: 
            case COPY: 
            case MOVE: {
                switch (this.m_sourceGraphSpecification) {
                    case ABSENT: {
                        break;
                    }
                    case DEFAULT: {
                        consumer.accept("DEFAULT");
                        break;
                    }
                    case NAMED: {
                        consumer.accept("NAMED");
                        break;
                    }
                    case ALL: {
                        consumer.accept("ALL");
                        break;
                    }
                    case GIVEN: {
                        consumer.accept("GRAPH ");
                        this.m_sourceGraph.toString(prefixes, consumer);
                    }
                }
                consumer.accept(" TO ");
                break;
            }
        }
        switch (this.m_targetGraphSpecification) {
            case ABSENT: {
                break;
            }
            case DEFAULT: {
                consumer.accept("DEFAULT");
                break;
            }
            case NAMED: {
                consumer.accept("NAMED");
                break;
            }
            case ALL: {
                consumer.accept("ALL");
                break;
            }
            case GIVEN: {
                consumer.accept("GRAPH ");
                this.m_targetGraph.toString(prefixes, consumer);
            }
        }
    }

    public static GraphUpdate create(GraphUpdateType graphUpdateType, boolean bl, GraphSpecification graphSpecification, Resource resource, GraphSpecification graphSpecification2, Resource resource2) {
        return InterningManager.s_instance.intern(GraphUpdate.hashCode(s_classHashCodeTimes31, Primes.SMALL_PRIMES[graphUpdateType.ordinal()], Primes.SMALL_PRIMES[bl ? 1 : 2], Primes.SMALL_PRIMES[graphSpecification.ordinal()], resource.hashCode(), Primes.SMALL_PRIMES[graphSpecification2.ordinal()], resource2.hashCode()), GraphUpdate.class, s_creator, graphUpdateType, bl, graphSpecification, resource, graphSpecification2, resource2);
    }

    @Override
    protected boolean interningEquals(Class<?> clazz, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return clazz == GraphUpdate.class && this.m_graphUpdateType.equals(object) && this.m_silent == (Boolean)object2 && this.m_sourceGraphSpecification.equals(object3) && this.m_sourceGraph.equals(object4) && this.m_targetGraphSpecification.equals(object5) && this.m_targetGraph.equals(object6);
    }

    protected Object readResolve() {
        return GraphUpdate.create(this.m_graphUpdateType, this.m_silent, this.m_sourceGraphSpecification, this.m_sourceGraph, this.m_targetGraphSpecification, this.m_targetGraph);
    }

    public static enum GraphSpecification {
        ABSENT,
        DEFAULT,
        NAMED,
        ALL,
        GIVEN;

    }

    public static enum GraphUpdateType {
        ADD,
        CLEAR,
        COPY,
        CREATE,
        DROP,
        MOVE;

    }
}

