/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.formats.internal;

import java.io.IOException;

public abstract class InputSource {
    protected int[] m_bufferedCodePoints = new int[10];
    protected int m_current = 0;
    protected int m_afterLast = 0;
    protected boolean m_doBuffer = false;

    public int takeSnapshot() {
        this.m_doBuffer = true;
        return this.m_current;
    }

    public void restoreSnapshot(int n) {
        this.m_doBuffer = false;
        this.m_current = n;
        if (this.m_current >= this.m_afterLast) {
            this.m_afterLast = 0;
            this.m_current = 0;
        }
    }

    public void stopBuffering() {
        this.m_doBuffer = false;
        if (this.m_current >= this.m_afterLast) {
            this.m_afterLast = 0;
            this.m_current = 0;
        }
    }

    public int nextCodePoint() throws IOException {
        if (this.m_current < this.m_afterLast) {
            int n = this.m_bufferedCodePoints[this.m_current++];
            if (!this.m_doBuffer && this.m_current >= this.m_afterLast) {
                this.m_afterLast = 0;
                this.m_current = 0;
            }
            return n;
        }
        if (this.m_doBuffer) {
            int n = this.readNextCodePoint();
            if (this.m_current >= this.m_bufferedCodePoints.length) {
                int[] nArray = new int[this.m_bufferedCodePoints.length * 3 / 2];
                System.arraycopy(this.m_bufferedCodePoints, 0, nArray, 0, this.m_bufferedCodePoints.length);
                this.m_bufferedCodePoints = nArray;
            }
            this.m_bufferedCodePoints[this.m_current++] = n;
            this.m_afterLast = this.m_current;
            return n;
        }
        return this.readNextCodePoint();
    }

    protected abstract int readNextCodePoint() throws IOException;
}

