/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.client;

import tech.oxfordsemantic.jrdfox.client.ComponentInfoMetric;

public class ComponentInfo {
    protected final Property[] m_properties;
    protected final ComponentInfo[] m_subComponents;

    public ComponentInfo(Property[] propertyArray, ComponentInfo[] componentInfoArray) {
        this.m_properties = propertyArray;
        this.m_subComponents = componentInfoArray;
        assert (this.getProperty(ComponentInfoMetric.IDENTIFIER, "Component name") != null) : "ComponentInfo must contain a name property.";
    }

    public int getNumberOfSubComponents() {
        return this.m_subComponents.length;
    }

    public ComponentInfo getSubComponent(int n) {
        return this.m_subComponents[n];
    }

    public ComponentInfo getSubComponent(String string) {
        for (ComponentInfo componentInfo : this.m_subComponents) {
            if (!componentInfo.getProperty(ComponentInfoMetric.IDENTIFIER, "Component name").getValue().equals(string)) continue;
            return componentInfo;
        }
        return null;
    }

    public int getNumberOfProperties() {
        return this.m_properties.length;
    }

    public Property getProperty(int n) {
        return this.m_properties[n];
    }

    public Property getProperty(ComponentInfoMetric componentInfoMetric, String string) {
        for (Property property : this.m_properties) {
            if (property.getMetric() != componentInfoMetric || (string != null || property.getUniqueName() != null) && (string == null || !string.equals(property.getUniqueName()))) continue;
            return property;
        }
        return null;
    }

    public static class Property {
        protected final ComponentInfoMetric m_metric;
        protected final String m_uniqueName;
        protected final Object m_value;

        public Property(ComponentInfoMetric componentInfoMetric, String string, Object object) {
            this.m_metric = componentInfoMetric;
            this.m_uniqueName = string;
            this.m_value = object;
        }

        public ComponentInfoMetric getMetric() {
            return this.m_metric;
        }

        public String getUniqueName() {
            return this.m_uniqueName;
        }

        public Object getValue() {
            return this.m_value;
        }
    }
}

