/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;

public class TurtleTriGWriter {
    protected final Prefixes m_prefixes;
    protected final PrintWriter m_output;
    protected final Consumer<String> m_outputConsumer;
    protected Resource m_currentGraph;
    protected Resource m_currentSubject;
    protected Resource m_currentPredicate;

    public TurtleTriGWriter(Prefixes prefixes, OutputStream outputStream) {
        this.m_prefixes = prefixes;
        this.m_output = new PrintWriter(outputStream, false, StandardCharsets.UTF_8);
        this.m_outputConsumer = new OutputConsumer(this.m_output);
        this.m_currentPredicate = null;
        this.m_currentSubject = null;
        this.m_currentGraph = null;
        if (!this.m_prefixes.getPrefixIRIsByPrefixName().isEmpty()) {
            for (Map.Entry<String, Prefixes.PrefixData> entry : this.m_prefixes.getPrefixIRIsByPrefixName().entrySet()) {
                this.m_output.print("@prefix ");
                this.m_output.print(entry.getKey());
                this.m_output.print(' ');
                this.m_output.print(entry.getValue().getEncodedIRI());
                this.m_output.println(" .");
            }
            this.m_output.println();
        }
    }

    protected void closeCurrentTriple() {
        this.m_output.println(" .");
        this.m_currentPredicate = null;
        this.m_currentSubject = null;
    }

    protected void openGraph(Resource resource) {
        this.m_output.print("GRAPH ");
        resource.toString(this.m_prefixes, this.m_outputConsumer);
        this.m_output.println(" {");
        this.m_output.println();
        this.m_currentGraph = resource;
        this.m_currentPredicate = null;
        this.m_currentSubject = null;
    }

    protected void closeCurrentGraph() {
        this.m_output.println();
        this.m_output.println();
        this.m_output.println("}");
        this.m_currentPredicate = null;
        this.m_currentSubject = null;
        this.m_currentGraph = null;
    }

    protected void writeTripleToCurrentGraph(Resource resource, Resource resource2, Resource resource3) {
        if (resource.equals(this.m_currentSubject) && resource2.equals(this.m_currentPredicate)) {
            this.m_output.print(" , ");
            resource3.toString(this.m_prefixes, this.m_outputConsumer);
        } else if (resource.equals(this.m_currentSubject)) {
            this.m_output.println(" ;");
            this.m_output.print("  ");
            resource2.toString(this.m_prefixes, this.m_outputConsumer);
            this.m_output.print(' ');
            resource3.toString(this.m_prefixes, this.m_outputConsumer);
        } else {
            if (this.m_currentSubject != null) {
                this.closeCurrentTriple();
            }
            resource.toString(this.m_prefixes, this.m_outputConsumer);
            this.m_output.print(' ');
            resource2.toString(this.m_prefixes, this.m_outputConsumer);
            this.m_output.print(' ');
            resource3.toString(this.m_prefixes, this.m_outputConsumer);
        }
        this.m_currentSubject = resource;
        this.m_currentPredicate = resource2;
    }

    public void writeTriple(Resource resource, Resource resource2, Resource resource3) {
        if (this.m_currentGraph != null) {
            this.closeCurrentGraph();
        }
        this.writeTripleToCurrentGraph(resource, resource2, resource3);
    }

    public void writeQuad(Resource resource, Resource resource2, Resource resource3, Resource resource4) {
        if (!resource4.equals(this.m_currentGraph)) {
            if (this.m_currentGraph != null) {
                this.closeCurrentGraph();
            } else if (this.m_currentSubject != null) {
                this.closeCurrentTriple();
            }
            this.openGraph(resource4);
        }
        this.writeTripleToCurrentGraph(resource, resource2, resource3);
    }

    public void flush() throws IOException {
        if (this.m_currentGraph != null) {
            this.closeCurrentGraph();
        } else if (this.m_currentSubject != null) {
            this.closeCurrentTriple();
        }
        this.m_output.flush();
        if (this.m_output.checkError()) {
            throw new IOException("Error encountered while writing to TurtleTrigWriter output stream");
        }
    }

    public void close() throws IOException {
        this.flush();
        this.m_output.close();
    }

    protected static class OutputConsumer
    implements Consumer<String> {
        protected final PrintWriter m_output;

        public OutputConsumer(PrintWriter printWriter) {
            this.m_output = printWriter;
        }

        @Override
        public void accept(String string) {
            this.m_output.print(string);
        }
    }
}

