/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.impl;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.client.DataStoreConnection;
import tech.oxfordsemantic.jrdfox.client.ServerConnection;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxDataStoreConnection;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxServerConnection;

public class JRDFoxServer {
    public static final String[] NO_STRINGS = new String[0];

    protected static native int nAnalyzeState(String var0) throws JRDFoxException;

    protected static native void nInitialize(String var0, String var1, String[] var2) throws JRDFoxException;

    protected static native void nUpgrade(String var0, String var1, OutputStream var2) throws JRDFoxException;

    protected static native int nStartServer(String[] var0) throws JRDFoxException;

    protected static native void nStopServer() throws JRDFoxException;

    protected static native long nGetNumberOfRoles() throws JRDFoxException;

    protected static native void nCreateFirstRole(String var0, String var1) throws JRDFoxException;

    protected static native long nNewServerConnection(String var0, String var1) throws JRDFoxException;

    protected static native long nNewDataStoreConnection(String var0, String var1, String var2) throws JRDFoxException;

    protected static native void nStartEndpoint(String[] var0) throws JRDFoxException;

    protected static native void nStopEndpoint() throws JRDFoxException;

    protected static String[] prefixesToStringArray(Prefixes prefixes) {
        Map<String, Prefixes.PrefixData> map = prefixes.getPrefixIRIsByPrefixName();
        if (map.isEmpty()) {
            return NO_STRINGS;
        }
        String[] stringArray = new String[2 * map.size()];
        int n = 0;
        for (Map.Entry<String, Prefixes.PrefixData> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                throw new NullPointerException();
            }
            stringArray[n++] = entry.getKey();
            stringArray[n++] = entry.getValue().getIRI();
        }
        return stringArray;
    }

    protected static String[] mapToStringArray(Map<String, String> map) {
        if (map.isEmpty()) {
            return NO_STRINGS;
        }
        String[] stringArray = new String[2 * map.size()];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                throw new NullPointerException();
            }
            stringArray[n++] = entry.getKey();
            stringArray[n++] = entry.getValue();
        }
        return stringArray;
    }

    protected static Map<String, String> stringArrayToMap(String[] stringArray, int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = stringArray.length;
        for (int i = n; i < n2; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    public static int analyzeState(String string) throws JRDFoxException {
        return JRDFoxServer.nAnalyzeState(string);
    }

    public static void initialize(String string, String string2, Map<String, String> map) throws JRDFoxException {
        JRDFoxServer.nInitialize(string, string2, JRDFoxServer.mapToStringArray(map));
    }

    public static void upgrade(String string, String string2, OutputStream outputStream) throws JRDFoxException {
        JRDFoxServer.nUpgrade(string, string2, outputStream);
    }

    public static int startServer(Map<String, String> map) throws JRDFoxException {
        return JRDFoxServer.nStartServer(JRDFoxServer.mapToStringArray(map));
    }

    public static void stopServer() throws JRDFoxException {
        JRDFoxServer.nStopServer();
    }

    public static long getNumberOfRoles() throws JRDFoxException {
        return JRDFoxServer.nGetNumberOfRoles();
    }

    public static void createFirstRole(String string, String string2) throws JRDFoxException {
        JRDFoxServer.nCreateFirstRole(string, string2);
    }

    public static ServerConnection newServerConnection(String string, String string2) throws JRDFoxException {
        long l = JRDFoxServer.nNewServerConnection(string, string2);
        try {
            return new JRDFoxServerConnection(l);
        }
        catch (Throwable throwable) {
            JRDFoxServerConnection.nClose(l);
            if (throwable instanceof JRDFoxException) {
                throw (JRDFoxException)throwable;
            }
            throw new JRDFoxException("Error while duplicating the connection.", throwable);
        }
    }

    public static DataStoreConnection newDataStoreConnection(String string, String string2, String string3) throws JRDFoxException {
        long l = JRDFoxServer.nNewDataStoreConnection(string, string2, string3);
        try {
            return new JRDFoxDataStoreConnection(string, l);
        }
        catch (Throwable throwable) {
            JRDFoxDataStoreConnection.nClose(l);
            if (throwable instanceof JRDFoxException) {
                throw (JRDFoxException)throwable;
            }
            throw new JRDFoxException("Error while duplicating the connection.", throwable);
        }
    }

    public static void startEndpoint(Map<String, String> map) throws JRDFoxException {
        JRDFoxServer.nStartEndpoint(JRDFoxServer.mapToStringArray(map));
    }

    public static void stopEndpoint() throws JRDFoxException {
        JRDFoxServer.nStopEndpoint();
    }
}

