/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.datalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.LogicVisitor;
import tech.oxfordsemantic.jrdfox.logic.datalog.Atom;
import tech.oxfordsemantic.jrdfox.logic.datalog.BodyFormula;
import tech.oxfordsemantic.jrdfox.logic.expression.Term;
import tech.oxfordsemantic.jrdfox.logic.expression.Variable;
import tech.oxfordsemantic.jrdfox.util.ImmutableArrayList;
import tech.oxfordsemantic.jrdfox.util.InterningManager;

public class Negation
extends BodyFormula {
    protected final ImmutableArrayList<Variable> m_existentialVariables;
    protected final ImmutableArrayList<Atom> m_negatedAtoms;
    private static final long serialVersionUID = 6178213383734890014L;
    protected static final int s_classHashCodeTimes31 = 31 * Negation.class.hashCode();
    protected static InterningManager.Creator s_creator = new InterningManager.Creator(){

        @Override
        public InterningManager.InternedObject create(Object object, Object object2) {
            return new Negation((List)object, (List)object2);
        }
    };

    protected static ImmutableArrayList<Term> getArguments(List<Atom> list, List<Variable> list2) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (list instanceof RandomAccess) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Atom atom = list.get(i);
                ImmutableArrayList immutableArrayList = atom.m_arguments;
                for (int j = 0; j < ((Term[])immutableArrayList.m_elements).length; ++j) {
                    Term term = ((Term[])immutableArrayList.m_elements)[j];
                    if (!(term instanceof Variable) || list2.contains(term)) continue;
                    arrayList.add(term);
                }
            }
        } else {
            for (Atom atom : list) {
                ImmutableArrayList immutableArrayList = atom.m_arguments;
                for (int i = 0; i < ((Term[])immutableArrayList.m_elements).length; ++i) {
                    Term term = ((Term[])immutableArrayList.m_elements)[i];
                    if (!(term instanceof Variable) || list2.contains(term)) continue;
                    arrayList.add(term);
                }
            }
        }
        return ImmutableArrayList.create(arrayList, Term.EMPTY_ARRAY);
    }

    protected Negation(List<Variable> list, List<Atom> list2) {
        super(Negation.getArguments(list2, list));
        this.m_existentialVariables = ImmutableArrayList.create(list, Variable.EMPTY_ARRAY);
        this.m_negatedAtoms = ImmutableArrayList.create(list2, Atom.EMPTY_ARRAY);
    }

    public List<Variable> getExistentialVariables() {
        return this.m_existentialVariables;
    }

    public List<Atom> getNegatedAtoms() {
        return this.m_negatedAtoms;
    }

    @Override
    public <E> E accept(LogicVisitor<E> logicVisitor) {
        return logicVisitor.visit(this);
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        int n;
        consumer.accept("NOT ");
        if (((Variable[])this.m_existentialVariables.m_elements).length != 0) {
            if (((Variable[])this.m_existentialVariables.m_elements).length == 1) {
                consumer.accept("EXISTS ");
            } else {
                consumer.accept("EXIST ");
            }
            for (n = 0; n < ((Variable[])this.m_existentialVariables.m_elements).length; ++n) {
                if (n != 0) {
                    consumer.accept(", ");
                }
                ((Variable[])this.m_existentialVariables.m_elements)[n].toString(prefixes, consumer);
            }
            consumer.accept(" IN ");
        }
        if (((Atom[])this.m_negatedAtoms.m_elements).length > 1) {
            consumer.accept("(");
            for (n = 0; n < ((Atom[])this.m_negatedAtoms.m_elements).length; ++n) {
                if (n != 0) {
                    consumer.accept(", ");
                }
                ((Atom[])this.m_negatedAtoms.m_elements)[n].toString(prefixes, consumer);
            }
            consumer.accept(")");
        } else {
            ((Atom[])this.m_negatedAtoms.m_elements)[0].toString(prefixes, consumer);
        }
    }

    public static Negation create(List<Variable> list, List<Atom> list2) {
        return InterningManager.s_instance.intern(Negation.hashCode(s_classHashCodeTimes31, Negation.hashCode(list), Negation.hashCode(list2)), Negation.class, s_creator, list, list2);
    }

    public static Negation create(Variable[] variableArray, Atom[] atomArray) {
        return Negation.create(Arrays.asList(variableArray), Arrays.asList(atomArray));
    }

    public static Negation create(Atom ... atomArray) {
        return Negation.create(Collections.emptyList(), Arrays.asList(atomArray));
    }

    @Override
    protected boolean interningEquals(Class<?> clazz, Object object, Object object2) {
        return clazz == Negation.class && Negation.flatEquals(this.m_existentialVariables, object) && Negation.flatEquals(this.m_negatedAtoms, object2);
    }

    protected Object readResolve() {
        return Negation.create(this.m_existentialVariables, this.m_negatedAtoms);
    }
}

