/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.client.UpdateType;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;
import tech.oxfordsemantic.jrdfox.exceptions.ParsingException;
import tech.oxfordsemantic.jrdfox.formats.internal.AbstractParser;
import tech.oxfordsemantic.jrdfox.formats.internal.CommonTokenizer;
import tech.oxfordsemantic.jrdfox.formats.internal.InputSource;
import tech.oxfordsemantic.jrdfox.formats.internal.UTF16InputSource;
import tech.oxfordsemantic.jrdfox.formats.internal.UTF8InputSource;
import tech.oxfordsemantic.jrdfox.logic.datalog.TupleTableName;
import tech.oxfordsemantic.jrdfox.logic.expression.BlankNode;
import tech.oxfordsemantic.jrdfox.logic.expression.Expression;
import tech.oxfordsemantic.jrdfox.logic.expression.IRI;
import tech.oxfordsemantic.jrdfox.logic.expression.Literal;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;
import tech.oxfordsemantic.jrdfox.logic.expression.Term;
import tech.oxfordsemantic.jrdfox.logic.expression.Variable;
import tech.oxfordsemantic.jrdfox.logic.sparql.path.AlternativePath;
import tech.oxfordsemantic.jrdfox.logic.sparql.path.CountingPath;
import tech.oxfordsemantic.jrdfox.logic.sparql.path.InversePath;
import tech.oxfordsemantic.jrdfox.logic.sparql.path.NegativePath;
import tech.oxfordsemantic.jrdfox.logic.sparql.path.Path;
import tech.oxfordsemantic.jrdfox.logic.sparql.path.ResourcePath;
import tech.oxfordsemantic.jrdfox.logic.sparql.path.SequencePath;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.BindPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.ConjunctionPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.DisjunctionPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.FilterPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.GraphPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.GroupGraphPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.MinusPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.OptionalPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.PathPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.QueryPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.ServicePattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.SubselectPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.TriplePattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.TupleTablePattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.ValuesPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.ConstructQuery;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.DeleteInsertUpdate;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.GraphUpdate;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.LoadUpdate;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Query;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.QueryBody;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.SelectQuery;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Statement;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Update;

public class SPARQLParser
extends AbstractParser {
    protected final InputSource m_inputSource;
    protected int m_nextAnonymousBNodeID;

    @Override
    protected void prefixMappingParsed(String string, String string2) throws ParsingException {
        Prefixes.DeclareResult declareResult = this.m_prefixes.declarePrefix(string, string2 = this.resolveIRI(string2));
        if (declareResult == Prefixes.DeclareResult.INVALID_PREFIX_NAME) {
            throw new ParsingException("Could not declare prefix '" + string + "' as IRI '<" + string2 + ">'.");
        }
        if (declareResult == Prefixes.DeclareResult.REPLACED_EXISTING) {
            throw new ParsingException("Prefix '" + string + "' has already been declared.");
        }
    }

    protected void parseBase() throws ParsingException, IOException {
        this.nextToken();
        if (!this.m_tokenizer.isQuotedIRI()) {
            throw new ParsingException("Base IRI of the form <IRI> expected.");
        }
        this.nextToken();
    }

    protected Term nextAnonymousBNode() {
        return BlankNode.create(String.format("anonymous%d", this.m_nextAnonymousBNodeID++));
    }

    protected boolean isValidFactPatternTerm(Term term, boolean bl) {
        return !bl || !(term instanceof Variable);
    }

    protected boolean isValidFactPattern(ConjunctionPattern conjunctionPattern, boolean bl, boolean bl2) {
        for (QueryPattern queryPattern : conjunctionPattern.getConjuncts()) {
            Object object;
            if (queryPattern instanceof GraphPattern) {
                object = (GraphPattern)queryPattern;
                if (!(((GraphPattern)object).getArgument() instanceof ConjunctionPattern) || !this.isValidFactPatternTerm(((GraphPattern)object).getGraph(), bl2)) {
                    return false;
                }
                for (QueryPattern queryPattern2 : ((ConjunctionPattern)((GraphPattern)object).getArgument()).getConjuncts()) {
                    if (!(queryPattern2 instanceof TriplePattern)) {
                        return false;
                    }
                    TriplePattern triplePattern = (TriplePattern)queryPattern2;
                    if (this.isValidFactPatternTerm(triplePattern.getSubject(), bl2) && this.isValidFactPatternTerm(triplePattern.getPredicate(), bl2) && this.isValidFactPatternTerm(triplePattern.getObject(), bl2)) continue;
                    return false;
                }
                continue;
            }
            if (queryPattern instanceof TriplePattern) {
                object = (TriplePattern)queryPattern;
                return this.isValidFactPatternTerm(((TriplePattern)object).getSubject(), bl2) && this.isValidFactPatternTerm(((TriplePattern)object).getPredicate(), bl2) && this.isValidFactPatternTerm(((TriplePattern)object).getSubject(), bl2);
            }
            if (!(queryPattern instanceof TupleTablePattern)) continue;
            if (!bl) {
                return false;
            }
            for (Term term : ((TupleTablePattern)queryPattern).getArguments()) {
                if (this.isValidFactPatternTerm(term, bl2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected GroupGraphPattern parseExistenceExpressionArgument() throws ParsingException, IOException {
        return this.parseGroupGraphPattern();
    }

    protected boolean parsePathModifier(Ref<CountingPath.PathCountType> ref) throws ParsingException, IOException {
        if (this.m_tokenizer.nonSymbolTokenEquals('?')) {
            ref.m_element = CountingPath.PathCountType.ZERO_OR_ONE;
        } else if (this.m_tokenizer.nonSymbolTokenEquals('*')) {
            ref.m_element = CountingPath.PathCountType.ZERO_OR_ANY;
        } else if (this.m_tokenizer.nonSymbolTokenEquals('+')) {
            ref.m_element = CountingPath.PathCountType.ONE_OR_ANY;
        } else {
            return false;
        }
        this.nextToken();
        return true;
    }

    protected NegativePath.NegatedPath parseOneInPropertySet() throws ParsingException, IOException {
        boolean bl;
        if (this.m_tokenizer.nonSymbolTokenEquals('^')) {
            this.nextToken();
            bl = true;
        } else {
            bl = false;
        }
        if (this.isResource()) {
            Resource resource = (Resource)this.parseTerm();
            return new NegativePath.NegatedPath(resource, bl);
        }
        throw new ParsingException("Invalid negated property path.");
    }

    protected Path parseNegativePath() throws ParsingException, IOException {
        assert (this.m_tokenizer.nonSymbolTokenEquals('!'));
        this.nextToken();
        ArrayList<NegativePath.NegatedPath> arrayList = new ArrayList<NegativePath.NegatedPath>();
        if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
            this.nextToken();
            if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                arrayList.add(this.parseOneInPropertySet());
                while (this.m_tokenizer.nonSymbolTokenEquals('|')) {
                    this.nextToken();
                    arrayList.add(this.parseOneInPropertySet());
                }
            }
            if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                throw new ParsingException("Unbalanced parentheses in a negated property path.");
            }
            this.nextToken();
        } else {
            arrayList.add(this.parseOneInPropertySet());
        }
        return NegativePath.create(arrayList);
    }

    protected Path parsePrimaryPath() throws ParsingException, IOException {
        if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
            this.nextToken();
            Path path = this.parsePath();
            if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                throw new ParsingException("Unbalanced parentheses in a property path.");
            }
            this.nextToken();
            return path;
        }
        if (this.m_tokenizer.nonSymbolTokenEquals('!')) {
            return this.parseNegativePath();
        }
        if (this.isResource()) {
            return ResourcePath.create((Resource)this.parseTerm());
        }
        throw new ParsingException("Invalid property path.");
    }

    protected Path parseElementaryPath() throws ParsingException, IOException {
        Path path = this.parsePrimaryPath();
        Ref<CountingPath.PathCountType> ref = new Ref<CountingPath.PathCountType>();
        if (this.parsePathModifier(ref)) {
            return CountingPath.create(path, (CountingPath.PathCountType)((Object)ref.m_element));
        }
        return path;
    }

    protected Path parseElementaryOrInversePath() throws ParsingException, IOException {
        if (this.m_tokenizer.nonSymbolTokenEquals('^')) {
            this.nextToken();
            Path path = this.parseElementaryPath();
            return InversePath.create(path);
        }
        return this.parseElementaryPath();
    }

    protected Path parseSequencePath() throws ParsingException, IOException {
        Path path = this.parseElementaryOrInversePath();
        if (this.m_tokenizer.nonSymbolTokenEquals('/')) {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            arrayList.add(path);
            while (this.m_tokenizer.nonSymbolTokenEquals('/')) {
                this.nextToken();
                arrayList.add(this.parseElementaryOrInversePath());
            }
            return SequencePath.create(arrayList);
        }
        return path;
    }

    protected Path parseAlternativePath() throws ParsingException, IOException {
        Path path = this.parseSequencePath();
        if (this.m_tokenizer.nonSymbolTokenEquals('|')) {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            arrayList.add(path);
            while (this.m_tokenizer.nonSymbolTokenEquals('|')) {
                this.nextToken();
                arrayList.add(this.parseSequencePath());
            }
            return AlternativePath.create(arrayList);
        }
        return path;
    }

    protected Path parsePath() throws ParsingException, IOException {
        return this.parseAlternativePath();
    }

    protected boolean parseTermOrPath(Pair<Term, Path> pair) throws ParsingException, IOException {
        if (this.m_tokenizer.nonSymbolTokenEquals('^') || this.m_tokenizer.nonSymbolTokenEquals('!') || this.m_tokenizer.nonSymbolTokenEquals('(')) {
            pair.m_second = this.parsePath();
            return true;
        }
        if (this.m_tokenizer.isVariable()) {
            pair.m_first = this.parseVariable();
            return true;
        }
        if (this.isResource()) {
            pair.m_first = this.parseTerm();
            if (this.m_tokenizer.nonSymbolTokenEqualsOneOf('?', '*', '+', '/', '|')) {
                ArrayList<Path> arrayList;
                pair.m_second = ResourcePath.create((Resource)pair.m_first);
                pair.m_first = null;
                Ref<CountingPath.PathCountType> ref = new Ref<CountingPath.PathCountType>();
                if (this.parsePathModifier(ref)) {
                    pair.m_second = CountingPath.create((Path)pair.m_second, (CountingPath.PathCountType)((Object)ref.m_element));
                }
                if (this.m_tokenizer.nonSymbolTokenEquals('/')) {
                    arrayList = new ArrayList<Path>();
                    arrayList.add((Path)pair.m_second);
                    while (this.m_tokenizer.nonSymbolTokenEquals('/')) {
                        this.nextToken();
                        arrayList.add(this.parseElementaryOrInversePath());
                    }
                    pair.m_second = SequencePath.create(arrayList);
                }
                if (this.m_tokenizer.nonSymbolTokenEquals('|')) {
                    arrayList = new ArrayList();
                    arrayList.add((Path)pair.m_second);
                    while (this.m_tokenizer.nonSymbolTokenEquals('|')) {
                        this.nextToken();
                        arrayList.add(this.parseSequencePath());
                    }
                    pair.m_second = AlternativePath.create(arrayList);
                }
            }
            return true;
        }
        return false;
    }

    protected ValuesPattern parseValuesPattern() throws ParsingException, IOException {
        assert (this.m_tokenizer.symbolLowerCaseTokenEquals("values"));
        this.nextToken();
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ArrayList<List<Resource>> arrayList2 = new ArrayList<List<Resource>>();
        if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
            this.nextToken();
            while (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                arrayList.add(this.parseVariable());
            }
            if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                throw new ParsingException("')' expected at the end of the variable list of a 'VALUES' pattern.");
            }
            this.nextToken();
            if (!this.m_tokenizer.nonSymbolTokenEquals('{')) {
                throw new ParsingException("'{' expected in the 'VALUES' pattern.");
            }
            this.nextToken();
            while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals('}')) {
                if (!this.m_tokenizer.nonSymbolTokenEquals('(')) {
                    throw new ParsingException("'(' must be used to start a 'VALUES' tuple.");
                }
                this.nextToken();
                ArrayList<Resource> arrayList3 = new ArrayList<Resource>();
                arrayList2.add(arrayList3);
                while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals(')')) {
                    if (this.m_tokenizer.symbolLowerCaseTokenEquals("undef")) {
                        this.nextToken();
                        arrayList3.add(Literal.UNDEF);
                        continue;
                    }
                    arrayList3.add((Resource)this.parseTerm());
                }
                if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                    throw new ParsingException("')' must be used to end a 'VALUES' tuple.");
                }
                this.nextToken();
                if (arrayList.size() == arrayList3.size()) continue;
                throw new ParsingException("The number of values in a tuple differs from the number of variables.");
            }
        } else {
            arrayList.add(this.parseVariable());
            if (!this.m_tokenizer.nonSymbolTokenEquals('{')) {
                throw new ParsingException("'{' expected in the 'VALUES' pattern.");
            }
            this.nextToken();
            while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals('}')) {
                ArrayList<Resource> arrayList4 = new ArrayList<Resource>();
                arrayList2.add(arrayList4);
                if (this.m_tokenizer.symbolLowerCaseTokenEquals("undef")) {
                    this.nextToken();
                    arrayList4.add(Literal.UNDEF);
                    continue;
                }
                arrayList4.add((Resource)this.parseTerm());
            }
        }
        if (!this.m_tokenizer.nonSymbolTokenEquals('}')) {
            throw new ParsingException("'}' expected at the end of a 'VALUES' pattern.");
        }
        this.nextToken();
        return ValuesPattern.create(arrayList, arrayList2);
    }

    protected Term parseCollection(List<QueryPattern> list, boolean[] blArray) throws ParsingException, IOException {
        this.nextToken();
        Term term = null;
        Term term2 = null;
        while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals(')')) {
            Term term3 = this.parseComplexTerm(list, blArray);
            Term term4 = this.nextAnonymousBNode();
            if (term2 == null) {
                term = term4;
            } else {
                list.add(TriplePattern.create(term2, IRI.RDF_REST, term4));
            }
            list.add(TriplePattern.create(term4, IRI.RDF_FIRST, term3));
            term2 = term4;
        }
        if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
            throw new ParsingException("A list should be terminated using the ')' character.");
        }
        this.nextToken();
        if (term == null) {
            return IRI.RDF_NIL;
        }
        list.add(TriplePattern.create(term2, IRI.RDF_REST, IRI.RDF_NIL));
        blArray[0] = true;
        return term;
    }

    protected Term parseNestedObject(List<QueryPattern> list, boolean[] blArray) throws ParsingException, IOException {
        this.nextToken();
        Term term = this.nextAnonymousBNode();
        this.parsePropertyList(term, list, blArray);
        if (!this.m_tokenizer.nonSymbolTokenEquals(']')) {
            throw new ParsingException("']' expected.");
        }
        this.nextToken();
        return term;
    }

    protected Term parseComplexTerm(List<QueryPattern> list, boolean[] blArray) throws ParsingException, IOException {
        if (this.m_tokenizer.nonSymbolTokenEquals('[')) {
            return this.parseNestedObject(list, blArray);
        }
        if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
            return this.parseCollection(list, blArray);
        }
        return this.parseTerm();
    }

    protected void parsePropertyList(Term term, List<QueryPattern> list, boolean[] blArray) throws ParsingException, IOException {
        Pair<Term, Path> pair = new Pair<Term, Path>();
        while (this.parseTermOrPath(pair)) {
            Term term2;
            assert (pair.m_first != null || pair.m_second != null);
            Term term3 = this.parseComplexTerm(list, blArray);
            if (pair.m_first != null) {
                term2 = null;
                if (this.m_tokenizer.symbolLowerCaseTokenEquals("explicit")) {
                    this.nextToken();
                    term2 = this.parseTerm();
                }
                list.add(TriplePattern.create(term, (Term)pair.m_first, term3, term2));
            } else {
                list.add(PathPattern.create(term, (Path)pair.m_second, term3));
            }
            blArray[0] = true;
            while (this.m_tokenizer.nonSymbolTokenEquals(',')) {
                this.nextToken();
                term3 = this.parseComplexTerm(list, blArray);
                if (pair.m_first != null) {
                    term2 = null;
                    if (this.m_tokenizer.symbolLowerCaseTokenEquals("explicit")) {
                        this.nextToken();
                        term2 = this.parseTerm();
                    }
                    list.add(TriplePattern.create(term, (Term)pair.m_first, term3, term2));
                    continue;
                }
                list.add(PathPattern.create(term, (Path)pair.m_second, term3));
            }
            if (!this.m_tokenizer.nonSymbolTokenEquals(';')) break;
            while (this.m_tokenizer.nonSymbolTokenEquals(';')) {
                this.nextToken();
            }
            pair.m_first = null;
            pair.m_second = null;
        }
    }

    protected void parseTripleOrPathPatterns(List<QueryPattern> list) throws ParsingException, IOException {
        boolean[] blArray = new boolean[1];
        Term term = this.m_tokenizer.isQuotedIRI() || this.m_tokenizer.is_PNAME_LN() || this.m_tokenizer.is_PNAME_NS() ? IRI.create(this.parseIRI()) : this.parseComplexTerm(list, blArray);
        this.parsePropertyList(term, list, blArray);
        if (!blArray[0]) {
            throw new ParsingException("A property of a triple should follow a subject.");
        }
    }

    protected boolean isUnion() throws ParsingException, IOException {
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("union")) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected GroupGraphPattern parseGroupGraphPattern() throws ParsingException, IOException {
        if (!this.m_tokenizer.nonSymbolTokenEquals('{')) {
            throw new ParsingException("'{' expected.");
        }
        this.nextToken();
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("select")) {
            SelectQuery selectQuery = this.parseSelectQuery(true, false);
            if (!this.m_tokenizer.nonSymbolTokenEquals('}')) {
                throw new ParsingException("'}' expected after a nested SELECT query.");
            }
            this.nextToken();
            return SubselectPattern.create(selectQuery);
        }
        return this.parseConjunctionPatternPastOpenBrace();
    }

    protected ConjunctionPattern parseConjunctionPatternPastOpenBrace() throws ParsingException, IOException {
        ArrayList<QueryPattern> arrayList = new ArrayList<QueryPattern>();
        ParseState parseState = ParseState.DOT_NOT_ALLOWED;
        while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals('}')) {
            Serializable serializable;
            if (this.m_tokenizer.nonSymbolTokenEquals('.')) {
                if (parseState == ParseState.DOT_NOT_ALLOWED) {
                    throw new ParsingException("'.' is not allowed.");
                }
                this.nextToken();
                parseState = ParseState.DOT_NOT_ALLOWED;
                continue;
            }
            if (this.m_tokenizer.nonSymbolTokenEquals('{')) {
                ArrayList<GroupGraphPattern> arrayList2 = new ArrayList<GroupGraphPattern>();
                do {
                    arrayList2.add(this.parseGroupGraphPattern());
                } while (this.isUnion());
                if (arrayList2.size() == 1) {
                    arrayList.add((QueryPattern)arrayList2.get(0));
                } else {
                    arrayList.add(DisjunctionPattern.create(arrayList2));
                }
                parseState = ParseState.DOT_OPTIONAL;
                continue;
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("bind")) {
                this.nextToken();
                if (!this.m_tokenizer.nonSymbolTokenEquals('(')) {
                    throw new ParsingException("Expected '(' after 'BIND'.");
                }
                this.nextToken();
                Expression expression = this.parseConditionalOrExpression();
                if (!this.m_tokenizer.symbolLowerCaseTokenEquals("as")) {
                    throw new ParsingException("Expected 'AS' after a bind expression.");
                }
                this.nextToken();
                serializable = this.parseVariable();
                if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                    throw new ParsingException("Expected ')' at the end of 'BIND'.");
                }
                this.nextToken();
                arrayList.add(BindPattern.create(expression, (Variable)serializable));
                parseState = ParseState.DOT_OPTIONAL;
                continue;
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("filter")) {
                this.nextToken();
                arrayList.add(FilterPattern.create(this.parseConstraintExpression()));
                parseState = ParseState.DOT_OPTIONAL;
                continue;
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("graph")) {
                Term term;
                this.nextToken();
                if (this.m_tokenizer.symbolLowerCaseTokenEquals("default")) {
                    this.nextToken();
                    term = Literal.UNDEF;
                } else {
                    term = this.parseTerm();
                }
                arrayList.add(GraphPattern.create(term, this.parseGroupGraphPattern()));
                parseState = ParseState.DOT_OPTIONAL;
                continue;
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("minus")) {
                this.nextToken();
                arrayList.add(MinusPattern.create(this.parseGroupGraphPattern()));
                parseState = ParseState.DOT_OPTIONAL;
                continue;
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("optional")) {
                this.nextToken();
                arrayList.add(OptionalPattern.create(this.parseGroupGraphPattern()));
                parseState = ParseState.DOT_OPTIONAL;
                continue;
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("service")) {
                this.nextToken();
                boolean bl = this.parseSilent();
                serializable = this.parseTerm();
                if (!(serializable instanceof IRI)) {
                    throw new ParsingException("A service endpoint must be an IRI.");
                }
                arrayList.add(ServicePattern.create((IRI)serializable, bl, this.parseGroupGraphPattern()));
                parseState = ParseState.DOT_OPTIONAL;
                continue;
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("tt")) {
                this.nextToken();
                if (this.m_tokenizer.getTokenType() != CommonTokenizer.TokenType.SYMBOL && this.m_tokenizer.getTokenType() != CommonTokenizer.TokenType.QUOTED_STRING) {
                    throw new ParsingException("A tuple table name must be a symbol or a string.");
                }
                TupleTableName tupleTableName = TupleTableName.create(this.m_tokenizer.getToken());
                this.nextToken();
                if (!this.m_tokenizer.nonSymbolTokenEquals('{')) {
                    throw new ParsingException("'{' expected.");
                }
                this.nextToken();
                serializable = new ArrayList();
                Term term = null;
                while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals('}') && !this.m_tokenizer.symbolLowerCaseTokenEquals("explicit")) {
                    serializable.add(this.parseTerm());
                }
                if (this.m_tokenizer.symbolLowerCaseTokenEquals("explicit")) {
                    this.nextToken();
                    term = this.parseTerm();
                }
                if (!this.m_tokenizer.nonSymbolTokenEquals('}')) {
                    throw new ParsingException("'}' expected.");
                }
                this.nextToken();
                arrayList.add(TupleTablePattern.create(tupleTableName, (List<Term>)((Object)serializable), term));
                parseState = ParseState.DOT_OPTIONAL;
                continue;
            }
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("values")) {
                arrayList.add(this.parseValuesPattern());
                parseState = ParseState.DOT_OPTIONAL;
                continue;
            }
            if (parseState == ParseState.AFTER_TRIPLE_PATTERN) {
                throw new ParsingException("A triple pattern must be terminated by '.' before another triple pattern can be started.");
            }
            this.parseTripleOrPathPatterns(arrayList);
            parseState = ParseState.AFTER_TRIPLE_PATTERN;
        }
        if (!this.m_tokenizer.nonSymbolTokenEquals('}')) {
            throw new ParsingException("'}' expected at the end of a basic graph pattern.");
        }
        this.nextToken();
        return ConjunctionPattern.create(arrayList);
    }

    @Override
    protected boolean isIRI() {
        switch (this.m_tokenizer.getTokenType()) {
            case QUOTED_IRI: 
            case PNAME_LN: 
            case PNAME_NS: {
                return true;
            }
            case SYMBOL: {
                return this.m_tokenizer.getToken().equals("a");
            }
        }
        return false;
    }

    protected ConjunctionPattern parseConjunctionPattern() throws ParsingException, IOException {
        if (!this.m_tokenizer.nonSymbolTokenEquals('{')) {
            throw new ParsingException("'{' expected.");
        }
        this.nextToken();
        return this.parseConjunctionPatternPastOpenBrace();
    }

    protected boolean parseAscDesc(Ref<QueryBody.SortOrder> ref) {
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("asc")) {
            ref.m_element = QueryBody.SortOrder.ASCENDING;
            return true;
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("desc")) {
            ref.m_element = QueryBody.SortOrder.DESCENDING;
            return true;
        }
        return false;
    }

    protected boolean parseOffsetLimit(boolean[] blArray) {
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("offset")) {
            blArray[0] = true;
            return true;
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("limit")) {
            blArray[0] = false;
            return true;
        }
        return false;
    }

    protected void parseOffsetLimitValue(boolean bl, QueryBody queryBody) throws ParsingException, IOException {
        if (this.m_tokenizer.isInteger()) {
            try {
                long l = Long.parseUnsignedLong(this.m_tokenizer.getToken());
                this.nextToken();
                if (bl) {
                    queryBody.setOffset(l);
                } else {
                    queryBody.setLimit(l);
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ParsingException(String.format("The %s value must be a nonnegative integer.", bl ? "OFFSET" : "LIMIT"));
    }

    protected QueryBody parseQueryBody(DatasetType datasetType, boolean bl) throws ParsingException, IOException {
        Object object;
        Object object2;
        QueryBody queryBody = QueryBody.createMutable();
        switch (datasetType) {
            case NONE: {
                break;
            }
            case FROM: 
            case USING: {
                while (this.m_tokenizer.symbolLowerCaseTokenEquals(datasetType == DatasetType.FROM ? "from" : "using")) {
                    this.nextToken();
                    if (this.m_tokenizer.symbolLowerCaseTokenEquals("named")) {
                        this.nextToken();
                        queryBody.getDatasetNamedGraphs().add(this.parseResource().toResource());
                        continue;
                    }
                    queryBody.getDatasetDefaultGraphs().add(this.parseResource().toResource());
                }
                break;
            }
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("where")) {
            this.nextToken();
        } else if (bl) {
            throw new ParsingException("'WHERE' expected.");
        }
        queryBody.setWherePattern(this.parseGroupGraphPattern());
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("group")) {
            this.nextToken();
            if (!this.m_tokenizer.symbolLowerCaseTokenEquals("by")) {
                throw new ParsingException("'BY' expected after 'GROUP'.");
            }
            this.nextToken();
            do {
                if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
                    this.nextToken();
                    object2 = this.parseConditionalOrExpression();
                    if (this.m_tokenizer.symbolLowerCaseTokenEquals("as")) {
                        this.nextToken();
                        object = this.parseVariable();
                        queryBody.getGroupBy().add(new QueryBody.GroupCondition((Expression)object2, (Variable)object));
                    } else if (object2 instanceof Variable) {
                        queryBody.getGroupBy().add(new QueryBody.GroupCondition((Expression)object2, (Variable)object2));
                    } else {
                        queryBody.getGroupBy().add(new QueryBody.GroupCondition((Expression)object2, null));
                    }
                    if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                        throw new ParsingException("')' expected in 'GROUP BY' expression.");
                    }
                    this.nextToken();
                    continue;
                }
                if (this.m_tokenizer.isVariable()) {
                    object2 = this.parseVariable();
                    queryBody.getGroupBy().add(new QueryBody.GroupCondition((Expression)object2, (Variable)object2));
                    continue;
                }
                queryBody.getGroupBy().add(new QueryBody.GroupCondition(this.parseConstraintExpression(), null));
            } while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals('}') && !this.m_tokenizer.symbolLowerCaseTokenEquals("having") && !this.m_tokenizer.symbolLowerCaseTokenEquals("order") && !this.m_tokenizer.symbolLowerCaseTokenEquals("offset") && !this.m_tokenizer.symbolLowerCaseTokenEquals("limit") && !this.m_tokenizer.symbolLowerCaseTokenEquals("values"));
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("having")) {
            this.nextToken();
            do {
                queryBody.getHaving().add(this.parseConstraintExpression());
            } while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals('}') && !this.m_tokenizer.symbolLowerCaseTokenEquals("order") && !this.m_tokenizer.symbolLowerCaseTokenEquals("offset") && !this.m_tokenizer.symbolLowerCaseTokenEquals("limit") && !this.m_tokenizer.symbolLowerCaseTokenEquals("values"));
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("order")) {
            this.nextToken();
            if (!this.m_tokenizer.symbolLowerCaseTokenEquals("by")) {
                throw new ParsingException("'BY' expected after 'ORDER'.");
            }
            this.nextToken();
            do {
                if (this.parseAscDesc((Ref<QueryBody.SortOrder>)(object2 = (Object)new Ref()))) {
                    this.nextToken();
                    if (!this.m_tokenizer.nonSymbolTokenEquals('(')) {
                        throw new ParsingException("'(' expected after 'ASC' or 'DESC'.");
                    }
                    this.nextToken();
                    object = this.parseConditionalOrExpression();
                    if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                        throw new ParsingException("')' expected after the 'ASC' or 'DESC' expression.");
                    }
                    this.nextToken();
                } else if (this.m_tokenizer.isVariable()) {
                    object2.m_element = QueryBody.SortOrder.ASCENDING;
                    object = this.parseVariable();
                } else {
                    object2.m_element = QueryBody.SortOrder.ASCENDING;
                    object = this.parseConstraintExpression();
                }
                queryBody.getOrderBy().add(new QueryBody.OrderCondition((QueryBody.SortOrder)((Object)object2.m_element), (Expression)object));
            } while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals('}') && !this.m_tokenizer.symbolLowerCaseTokenEquals("offset") && !this.m_tokenizer.symbolLowerCaseTokenEquals("limit") && !this.m_tokenizer.symbolLowerCaseTokenEquals("values"));
        }
        if (this.parseOffsetLimit((boolean[])(object2 = new boolean[1]))) {
            this.nextToken();
            this.parseOffsetLimitValue(object2[0], queryBody);
            object = new boolean[1];
            if (this.parseOffsetLimit((boolean[])object)) {
                if (object2 == object) {
                    throw new ParsingException(String.format("At most one %s modifier is allowed.", object2[0] ? "OFFSET" : "LIMIT"));
                }
                this.nextToken();
                this.parseOffsetLimitValue(object[0], queryBody);
            }
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("values")) {
            queryBody.setValuesPattern(this.parseValuesPattern());
        }
        return queryBody;
    }

    protected SelectQuery parseSelectQuery(boolean bl, boolean bl2) throws ParsingException, IOException {
        Serializable serializable;
        boolean bl3;
        boolean bl4;
        this.nextToken();
        ArrayList<SelectQuery.SelectionPair> arrayList = new ArrayList<SelectQuery.SelectionPair>();
        if (bl) {
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("distinct")) {
                this.nextToken();
                bl4 = true;
            } else {
                if (this.m_tokenizer.symbolLowerCaseTokenEquals("reduced")) {
                    this.nextToken();
                }
                bl4 = false;
            }
            if (this.m_tokenizer.nonSymbolTokenEquals('*')) {
                bl3 = true;
                this.nextToken();
            } else {
                bl3 = false;
                while (this.m_tokenizer.isGood() && !this.m_tokenizer.symbolLowerCaseTokenEquals("from") && !this.m_tokenizer.symbolLowerCaseTokenEquals("where") && !this.m_tokenizer.nonSymbolTokenEquals('{')) {
                    if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
                        this.nextToken();
                        serializable = this.parseConditionalOrExpression();
                        if (!this.m_tokenizer.symbolLowerCaseTokenEquals("as")) {
                            throw new ParsingException("'AS' expected in the (<function> AS <var>) expression.");
                        }
                        this.nextToken();
                        Variable variable = this.parseVariable();
                        if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                            throw new ParsingException("')' expected in the (<function> AS <var>) expression.");
                        }
                        this.nextToken();
                        arrayList.add(new SelectQuery.SelectionPair((Expression)serializable, variable));
                        continue;
                    }
                    serializable = this.parseVariable();
                    arrayList.add(new SelectQuery.SelectionPair((Expression)serializable, (Variable)serializable));
                }
            }
        } else {
            bl4 = true;
            bl3 = false;
        }
        serializable = this.parseQueryBody(bl2 ? DatasetType.FROM : DatasetType.USING, false);
        return SelectQuery.create(bl4, bl3, arrayList, serializable);
    }

    protected ConstructQuery parseConstructQuery() throws ParsingException, IOException {
        boolean bl;
        this.nextToken();
        ConjunctionPattern conjunctionPattern = null;
        if (this.m_tokenizer.nonSymbolTokenEquals('{')) {
            conjunctionPattern = this.parseConjunctionPattern();
            if (!this.isValidFactPattern(conjunctionPattern, false, false)) {
                throw new ParsingException("The template of a 'CONSTRUCT' query can contain only triple and quad patterns.");
            }
            bl = false;
        } else {
            bl = true;
        }
        QueryBody queryBody = this.parseQueryBody(DatasetType.FROM, bl);
        if (bl) {
            if (!(queryBody.getWherePattern() instanceof ConjunctionPattern)) {
                throw new ParsingException("Only triple and quad patterns are allowed to occur in a 'CONSTRUCT WHERE' query.");
            }
            conjunctionPattern = (ConjunctionPattern)queryBody.getWherePattern();
            if (!this.isValidFactPattern(conjunctionPattern, false, false)) {
                throw new ParsingException("Only triple and quad patterns are allowed to occur in a 'CONSTRUCT WHERE' query.");
            }
        }
        return ConstructQuery.create(conjunctionPattern, queryBody);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected DeleteInsertUpdate parseDeleteInsertUpdate() throws ParsingException, IOException {
        ConjunctionPattern conjunctionPattern;
        ConjunctionPattern conjunctionPattern2;
        boolean bl;
        void var1_4;
        block17: {
            block16: {
                Object var1_1 = null;
                if (this.m_tokenizer.symbolLowerCaseTokenEquals("with")) {
                    this.nextToken();
                    Resource resource = this.parseResource().toResource();
                } else {
                    Literal literal = Literal.UNDEF;
                }
                boolean bl2 = this.m_tokenizer.symbolLowerCaseTokenEquals("delete");
                if (!bl2 && !this.m_tokenizer.symbolLowerCaseTokenEquals("insert")) {
                    throw new ParsingException("'DELETE' or 'INSERT' expected.");
                }
                this.nextToken();
                if (this.m_tokenizer.symbolLowerCaseTokenEquals("data")) {
                    this.nextToken();
                    ConjunctionPattern conjunctionPattern3 = this.parseConjunctionPattern();
                    if (!this.isValidFactPattern(conjunctionPattern3, true, true)) {
                        throw new ParsingException(String.format("Only triple, quad, and tuple table patterns without variables are allowed to occur in a%s DATA' update.", bl2 ? "'DELETE" : "n 'INSERT"));
                    }
                    QueryBody queryBody = QueryBody.createMutable();
                    queryBody.setWherePattern(ConjunctionPattern.create(Collections.emptyList()));
                    ConjunctionPattern conjunctionPattern4 = ConjunctionPattern.create(Collections.emptyList());
                    if (bl2) {
                        return DeleteInsertUpdate.create((Resource)var1_4, conjunctionPattern3, conjunctionPattern4, queryBody);
                    }
                    return DeleteInsertUpdate.create((Resource)var1_4, conjunctionPattern4, conjunctionPattern3, queryBody);
                }
                bl = false;
                if (!bl2) break block16;
                if (this.m_tokenizer.nonSymbolTokenEquals('{')) {
                    conjunctionPattern2 = this.parseConjunctionPattern();
                    if (!this.isValidFactPattern(conjunctionPattern2, true, false)) {
                        throw new ParsingException("Only triple, quad, and tuple table patterns are allowed to occur in a 'DELETE' template.");
                    }
                    if (this.m_tokenizer.symbolLowerCaseTokenEquals("insert")) {
                        this.nextToken();
                        bl = true;
                    }
                    break block17;
                } else {
                    if (!this.m_tokenizer.symbolLowerCaseTokenEquals("where")) {
                        throw new ParsingException("Invalid text after 'DELETE'.");
                    }
                    this.nextToken();
                    ConjunctionPattern conjunctionPattern5 = this.parseConjunctionPattern();
                    if (!this.isValidFactPattern(conjunctionPattern5, true, false)) {
                        throw new ParsingException("Only triple, quad, and tuple table patterns are allowed to occur in a 'DELETE WHERE' update.");
                    }
                    QueryBody queryBody = QueryBody.createMutable();
                    queryBody.setWherePattern(conjunctionPattern5);
                    ConjunctionPattern conjunctionPattern6 = ConjunctionPattern.create(Collections.emptyList());
                    return DeleteInsertUpdate.create((Resource)var1_4, conjunctionPattern5, conjunctionPattern6, queryBody);
                }
            }
            conjunctionPattern2 = ConjunctionPattern.create(Collections.emptyList());
            bl = true;
        }
        if (bl) {
            if (!this.m_tokenizer.nonSymbolTokenEquals('{')) {
                throw new ParsingException("Invalid text after 'INSERT'.");
            }
            conjunctionPattern = this.parseConjunctionPattern();
            if (!this.isValidFactPattern(conjunctionPattern, true, false)) {
                throw new ParsingException("Only triple, quad, and tuple table patterns are allowed to occur in an 'INSERT' template.");
            }
        } else {
            conjunctionPattern = ConjunctionPattern.create(Collections.emptyList());
        }
        QueryBody queryBody = this.parseQueryBody(DatasetType.USING, true);
        return DeleteInsertUpdate.create((Resource)var1_4, conjunctionPattern2, conjunctionPattern, queryBody);
    }

    protected void parseGraphSpectification(GraphSpecificationVariant graphSpecificationVariant, Ref<GraphUpdate.GraphSpecification> ref, Ref<Resource> ref2) throws ParsingException, IOException {
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("graph")) {
            this.nextToken();
            ref.m_element = GraphUpdate.GraphSpecification.GIVEN;
            ref2.m_element = this.parseResource().toResource();
        } else if (graphSpecificationVariant != GraphSpecificationVariant.GIVEN && this.m_tokenizer.symbolLowerCaseTokenEquals("default")) {
            this.nextToken();
            ref.m_element = GraphUpdate.GraphSpecification.DEFAULT;
            ref2.m_element = Literal.UNDEF;
        } else if (graphSpecificationVariant == GraphSpecificationVariant.GIVEN_DEFAULT_NAMED_ALL && this.m_tokenizer.symbolLowerCaseTokenEquals("named")) {
            this.nextToken();
            ref.m_element = GraphUpdate.GraphSpecification.NAMED;
            ref2.m_element = Literal.UNDEF;
        } else if (graphSpecificationVariant == GraphSpecificationVariant.GIVEN_DEFAULT_NAMED_ALL && this.m_tokenizer.symbolLowerCaseTokenEquals("all")) {
            this.nextToken();
            ref.m_element = GraphUpdate.GraphSpecification.ALL;
            ref2.m_element = Literal.UNDEF;
        } else if (graphSpecificationVariant == GraphSpecificationVariant.GIVEN_DEFAULT) {
            ref.m_element = GraphUpdate.GraphSpecification.GIVEN;
            ref2.m_element = this.parseResource().toResource();
        } else {
            throw new ParsingException("Invalid graph specification.");
        }
    }

    protected boolean parseSilent() throws ParsingException, IOException {
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("silent")) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected GraphUpdate parseGraphUpdate1(GraphUpdate.GraphUpdateType graphUpdateType, GraphSpecificationVariant graphSpecificationVariant) throws ParsingException, IOException {
        this.nextToken();
        boolean bl = this.parseSilent();
        Ref<GraphUpdate.GraphSpecification> ref = new Ref<GraphUpdate.GraphSpecification>();
        Ref<Resource> ref2 = new Ref<Resource>();
        this.parseGraphSpectification(graphSpecificationVariant, ref, ref2);
        return GraphUpdate.create(graphUpdateType, bl, GraphUpdate.GraphSpecification.ABSENT, Literal.UNDEF, (GraphUpdate.GraphSpecification)((Object)ref.m_element), (Resource)ref2.m_element);
    }

    protected GraphUpdate parseGraphUpdate2(GraphUpdate.GraphUpdateType graphUpdateType) throws ParsingException, IOException {
        this.nextToken();
        boolean bl = this.parseSilent();
        Ref<GraphUpdate.GraphSpecification> ref = new Ref<GraphUpdate.GraphSpecification>();
        Ref<Resource> ref2 = new Ref<Resource>();
        Ref<GraphUpdate.GraphSpecification> ref3 = new Ref<GraphUpdate.GraphSpecification>();
        Ref<Resource> ref4 = new Ref<Resource>();
        this.parseGraphSpectification(GraphSpecificationVariant.GIVEN_DEFAULT, ref, ref2);
        if (!this.m_tokenizer.symbolLowerCaseTokenEquals("to")) {
            throw new ParsingException("'TO' expected.");
        }
        this.nextToken();
        this.parseGraphSpectification(GraphSpecificationVariant.GIVEN_DEFAULT, ref3, ref4);
        return GraphUpdate.create(graphUpdateType, bl, (GraphUpdate.GraphSpecification)((Object)ref.m_element), (Resource)ref2.m_element, (GraphUpdate.GraphSpecification)((Object)ref3.m_element), (Resource)ref4.m_element);
    }

    protected Statement parseNextStatementInternal() throws ParsingException, IOException {
        Statement statement;
        this.m_nextAnonymousBNodeID = 0;
        while (true) {
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("prefix")) {
                this.parsePrefixMapping();
                continue;
            }
            if (!this.m_tokenizer.symbolLowerCaseTokenEquals("base")) break;
            this.parseBase();
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("select")) {
            statement = this.parseSelectQuery(true, true);
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("ask")) {
            statement = this.parseSelectQuery(false, true);
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("construct")) {
            statement = this.parseConstructQuery();
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("delete") || this.m_tokenizer.symbolLowerCaseTokenEquals("insert") || this.m_tokenizer.symbolLowerCaseTokenEquals("with")) {
            statement = this.parseDeleteInsertUpdate();
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("clear")) {
            statement = this.parseGraphUpdate1(GraphUpdate.GraphUpdateType.CLEAR, GraphSpecificationVariant.GIVEN_DEFAULT_NAMED_ALL);
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("drop")) {
            statement = this.parseGraphUpdate1(GraphUpdate.GraphUpdateType.DROP, GraphSpecificationVariant.GIVEN_DEFAULT_NAMED_ALL);
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("create")) {
            statement = this.parseGraphUpdate1(GraphUpdate.GraphUpdateType.CREATE, GraphSpecificationVariant.GIVEN);
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("add")) {
            statement = this.parseGraphUpdate2(GraphUpdate.GraphUpdateType.ADD);
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("move")) {
            statement = this.parseGraphUpdate2(GraphUpdate.GraphUpdateType.MOVE);
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("copy")) {
            statement = this.parseGraphUpdate2(GraphUpdate.GraphUpdateType.COPY);
        } else if (this.m_tokenizer.symbolLowerCaseTokenEquals("load") || this.m_tokenizer.symbolLowerCaseTokenEquals("unload")) {
            UpdateType updateType = this.m_tokenizer.symbolLowerCaseTokenEquals("load") ? UpdateType.ADDITION : UpdateType.DELETION;
            this.nextToken();
            boolean bl = this.parseSilent();
            String string = this.parseIRI();
            if (string == null) {
                throw new ParsingException("An IRI designating the source to be loaded was expected.");
            }
            TupleTableName tupleTableName = null;
            if (this.m_tokenizer.symbolLowerCaseTokenEquals("into")) {
                this.nextToken();
                if (!this.m_tokenizer.symbolLowerCaseTokenEquals("graph")) {
                    throw new ParsingException("'GRAPH' was expected.");
                }
                this.nextToken();
                String string2 = this.parseIRI();
                if (string2 == null) {
                    throw new ParsingException("An IRI designating the target graph was expected.");
                }
                tupleTableName = TupleTableName.create(string2);
            }
            statement = LoadUpdate.create(bl, updateType, string, tupleTableName);
        } else {
            throw new ParsingException("Unknown token '" + this.m_tokenizer.getToken() + "'.");
        }
        return statement;
    }

    public SPARQLParser(String string, Prefixes prefixes, InputSource inputSource) throws IOException, ParsingException {
        this.m_baseIRI = URI.create(string);
        this.m_prefixes = prefixes;
        this.m_inputSource = inputSource;
        this.m_tokenizer = new CommonTokenizer(this.m_inputSource);
        this.nextToken();
    }

    public SPARQLParser(String string, Prefixes prefixes, InputStream inputStream) throws IOException, ParsingException {
        this(string, prefixes, new UTF8InputSource(inputStream));
    }

    public SPARQLParser(String string, Prefixes prefixes, Reader reader) throws IOException, ParsingException {
        this(string, prefixes, new UTF16InputSource(reader));
    }

    public Statement parseSingleStatement() throws JRDFoxException, IOException {
        Statement statement = this.parseNextStatement();
        if (!this.m_tokenizer.isEOF()) {
            throw new ParsingException("Unexpected characters after the end of a query or an update.");
        }
        return statement;
    }

    public Statement parseNextStatement() throws IOException, ParsingException {
        Statement statement = this.parseNextStatementInternal();
        if (this.m_tokenizer.nonSymbolTokenEquals(';')) {
            this.nextToken();
        }
        return statement;
    }

    public boolean hasMoreStatements() {
        return !this.m_tokenizer.isEOF();
    }

    public Query parseSingleQuery() throws JRDFoxException, IOException {
        Statement statement = this.parseNextStatement();
        if (!this.m_tokenizer.isEOF()) {
            throw new ParsingException("Unexpected characters after the end of a query.");
        }
        if (statement instanceof Query) {
            return (Query)statement;
        }
        throw new ParsingException("A query (rather than an update) was expected.");
    }

    public Update parseSingleUpdate() throws JRDFoxException, IOException {
        Statement statement = this.parseNextStatement();
        if (!this.m_tokenizer.isEOF()) {
            throw new ParsingException("Unexpected characters after the end of an update.");
        }
        if (statement instanceof Query) {
            throw new ParsingException("An update (rather than a query) was expected.");
        }
        return (Update)statement;
    }

    protected static class Ref<T> {
        T m_element = null;

        protected Ref() {
        }
    }

    protected static class Pair<T1, T2> {
        T1 m_first = null;
        T2 m_second = null;

        protected Pair() {
        }
    }

    protected static enum ParseState {
        DOT_NOT_ALLOWED,
        DOT_OPTIONAL,
        AFTER_TRIPLE_PATTERN;

    }

    protected static enum DatasetType {
        NONE,
        FROM,
        USING;

    }

    protected static enum GraphSpecificationVariant {
        GIVEN,
        GIVEN_DEFAULT,
        GIVEN_DEFAULT_NAMED_ALL;

    }
}

