/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.client.CommitProcedureInfo;
import tech.oxfordsemantic.jrdfox.client.ComponentInfo;
import tech.oxfordsemantic.jrdfox.client.Cursor;
import tech.oxfordsemantic.jrdfox.client.CursorType;
import tech.oxfordsemantic.jrdfox.client.DataSourceInfo;
import tech.oxfordsemantic.jrdfox.client.DataSourceTableInfo;
import tech.oxfordsemantic.jrdfox.client.DataStoreConnection;
import tech.oxfordsemantic.jrdfox.client.DataStoreOperationStartMonitor;
import tech.oxfordsemantic.jrdfox.client.DeltaQueryAnswerInfo;
import tech.oxfordsemantic.jrdfox.client.DeltaQueryAnswerType;
import tech.oxfordsemantic.jrdfox.client.DeltaQueryEvaluationMode;
import tech.oxfordsemantic.jrdfox.client.DeltaQueryInfo;
import tech.oxfordsemantic.jrdfox.client.ExplanationType;
import tech.oxfordsemantic.jrdfox.client.ImportNotificationMonitor;
import tech.oxfordsemantic.jrdfox.client.ImportResult;
import tech.oxfordsemantic.jrdfox.client.InputSourceFactory;
import tech.oxfordsemantic.jrdfox.client.QueryAnswerMonitor;
import tech.oxfordsemantic.jrdfox.client.ReasoningAlgorithm;
import tech.oxfordsemantic.jrdfox.client.ResourceValue;
import tech.oxfordsemantic.jrdfox.client.RuleInfo;
import tech.oxfordsemantic.jrdfox.client.StatementResult;
import tech.oxfordsemantic.jrdfox.client.StatisticsInfo;
import tech.oxfordsemantic.jrdfox.client.TransactionState;
import tech.oxfordsemantic.jrdfox.client.TransactionType;
import tech.oxfordsemantic.jrdfox.client.TupleTableInfo;
import tech.oxfordsemantic.jrdfox.client.UpdateType;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxCursor;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxQueryAnswerMonitor;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxResourceValue;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxResourceValueCache;
import tech.oxfordsemantic.jrdfox.impl.JRDFoxServer;
import tech.oxfordsemantic.jrdfox.logic.Datatype;
import tech.oxfordsemantic.jrdfox.logic.datalog.Rule;
import tech.oxfordsemantic.jrdfox.logic.datalog.TupleTableAtom;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Query;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Statement;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Update;

public class JRDFoxDataStoreConnection
implements DataStoreConnection {
    protected static final Rule[] NO_RULES = new Rule[0];
    protected static final String GUESS_FORMAT_NAME = new String();
    protected final String m_name;
    protected long m_dataStoreConnectionPtr;
    protected final JRDFoxResourceValueCache m_resourceValueCache;
    protected final String m_uniqueID;
    protected final boolean m_isPersistent;
    protected final Map<String, String> m_parameters;
    protected final AtomicBoolean m_inUse;
    protected int m_numberOfCursors;

    protected static native void nClose(long var0);

    protected static native void nInterrupt(long var0) throws JRDFoxException;

    protected static native String nGetAgentName(long var0) throws JRDFoxException;

    protected static native void nCheckPassword(long var0, String var2) throws JRDFoxException;

    protected static native long nGetLockTimeout(long var0) throws JRDFoxException;

    protected static native void nSetLockTimeout(long var0, long var2) throws JRDFoxException;

    protected static native DataStoreOperationStartMonitor nGetDataStoreOperationStartMonitor(long var0) throws JRDFoxException;

    protected static native void nSetDataStoreOperationStartMonitor(long var0, DataStoreOperationStartMonitor var2) throws JRDFoxException;

    protected static native long nDuplicate(long var0) throws JRDFoxException;

    protected static native String[] nDescribeDataStore(long var0, String[] var2, boolean[] var3) throws JRDFoxException;

    protected static native ComponentInfo nGetComponentInfo(long var0, boolean var2) throws JRDFoxException;

    protected static native String[] nGetDataStoreProperties(long var0) throws JRDFoxException;

    protected static native String nGetDataStoreProperty(long var0, String var2) throws JRDFoxException;

    protected static native boolean nSetDataStoreProperty(long var0, String var2, String var3) throws JRDFoxException;

    protected static native Prefixes nGetPrefixes(long var0) throws JRDFoxException;

    protected static native boolean nSetPrefixes(long var0, Prefixes var2) throws JRDFoxException;

    protected static native boolean nSetPrefix(long var0, String var2, String var3) throws JRDFoxException;

    protected static native boolean nUnsetPrefix(long var0, String var2) throws JRDFoxException;

    protected static native Map<String, Optional<DataSourceInfo>> nListDataSources(long var0) throws JRDFoxException;

    protected static native boolean nContainsDataSource(long var0, String var2) throws JRDFoxException;

    protected static native DataSourceInfo nDescribeDataSource(long var0, String var2) throws JRDFoxException;

    protected static native void nRegisterDataSource(long var0, String var2, String[] var3) throws JRDFoxException;

    protected static native void nDeregisterDataSource(long var0, String var2) throws JRDFoxException;

    protected static native DataSourceTableInfo[] nListDataSourceTables(long var0, String var2) throws JRDFoxException;

    protected static native boolean nContainsDataSourceTable(long var0, String var2, String var3) throws JRDFoxException;

    protected static native DataSourceTableInfo nDescribeDataSourceTable(long var0, String var2, String var3) throws JRDFoxException;

    protected static native Object[] nGetDataSourceTableData(long var0, String var2, String var3, int var4) throws JRDFoxException;

    protected static native Map<String, Optional<TupleTableInfo>> nListTupleTables(long var0) throws JRDFoxException;

    protected static native boolean nContainsTupleTable(long var0, String var2) throws JRDFoxException;

    protected static native TupleTableInfo nDescribeTupleTable(long var0, String var2) throws JRDFoxException;

    protected static native void nCreateTupleTable(long var0, String var2, String[] var3) throws JRDFoxException;

    protected static native void nDeleteTupleTable(long var0, String var2) throws JRDFoxException;

    protected static native StatisticsInfo[] nListStatistics(long var0) throws JRDFoxException;

    protected static native boolean nContainsStatistics(long var0, String var2) throws JRDFoxException;

    protected static native StatisticsInfo nDescribeStatistics(long var0, String var2) throws JRDFoxException;

    protected static native void nCreateStatistics(long var0, String var2, String[] var3) throws JRDFoxException;

    protected static native void nDeleteStatistics(long var0, String var2) throws JRDFoxException;

    protected static native void nUpdateStatisticsAll(long var0) throws JRDFoxException;

    protected static native void nUpdateStatisticsOne(long var0, String var2) throws JRDFoxException;

    protected static native long nGetDataStoreVersionAfterLastOperation(long var0) throws JRDFoxException;

    protected static native long nGetDataStoreVersion(long var0) throws JRDFoxException;

    protected static native long nGetLastSnapshotDataStoreVersion(long var0) throws JRDFoxException;

    protected static native CommitProcedureInfo nGetCommitProcedure(long var0) throws JRDFoxException;

    protected static native boolean nSetCommitProcedure(long var0, String var2) throws JRDFoxException;

    protected static native Map<String, Optional<DeltaQueryInfo>> nListDeltaQueries(long var0) throws JRDFoxException;

    protected static native boolean nContainsDeltaQuery(long var0, String var2) throws JRDFoxException;

    protected static native DeltaQueryInfo nDescribeDeltaQuery(long var0, String var2) throws JRDFoxException;

    protected static native void nRegisterDeltaQuery(long var0, String var2, String var3, String var4, long var5, long var7, long var9) throws JRDFoxException;

    protected static native void nDeregisterDeltaQuery(long var0, String var2) throws JRDFoxException;

    protected static native void nSetDeltaQueryEvaluationMode(long var0, String var2, int var3) throws JRDFoxException;

    protected static native DeltaQueryAnswerInfo[] nListDeltaQueryAnswers(long var0, Optional<String> var2, Optional<Long> var3, Optional<Long> var4, Optional<Integer> var5) throws JRDFoxException;

    protected static native long nDeleteDeltaQueryAnswers(long var0, Optional<String> var2, Optional<Long> var3, Optional<Long> var4, Optional<Integer> var5) throws JRDFoxException;

    protected static native void nExportDeltaQueryAnswer(long var0, OutputStream var2, String var3, long var4, int var6) throws JRDFoxException;

    protected static native int nGetTransactionState(long var0) throws JRDFoxException;

    protected static native boolean nTransactionRequiresRollback(long var0) throws JRDFoxException;

    protected static native void nBeginTransaction(long var0, int var2) throws JRDFoxException;

    protected static native void nCommitTransaction(long var0) throws JRDFoxException;

    protected static native void nRollbackTransaction(long var0) throws JRDFoxException;

    protected static native void nCompact(long var0) throws JRDFoxException;

    protected static native void nClear(long var0, int var2) throws JRDFoxException;

    protected static native void nClearRulesAxiomsExplicateFacts(long var0) throws JRDFoxException;

    protected static native void nExportDataStream(long var0, OutputStream var2, String var3, String[] var4) throws JRDFoxException;

    protected static native void nExportDataFile(long var0, String var2, String var3, String var4, String var5, String[] var6) throws JRDFoxException;

    protected static native ImportResult nImportDataOne(long var0, String var2, short var3, int var4, InputSourceFactory var5, String var6, ImportNotificationMonitor var7) throws JRDFoxException;

    protected static native ImportResult nImportDataMany(long var0, String var2, short var3, int var4, InputSourceFactory[] var5, String var6, ImportNotificationMonitor var7) throws JRDFoxException;

    protected static native ImportResult nImportAxiomsFromTriples(long var0, String var2, short var3, boolean var4, String var5, short var6, int var7, ImportNotificationMonitor var8) throws JRDFoxException;

    protected static native RuleInfo[] nListRules(long var0) throws JRDFoxException;

    protected static native long nAddDeleteRules(long var0, int var2, String var3) throws JRDFoxException;

    protected static native void nRecompile(long var0) throws JRDFoxException;

    protected static native boolean nGetIncrementalReasoningAllowed(long var0) throws JRDFoxException;

    protected static native void nSetIncrementalReasoningAllowed(long var0, boolean var2) throws JRDFoxException;

    protected static native int nGetDataStoreReasoningAlgorithm(long var0) throws JRDFoxException;

    protected static native void nUpdateMaterialization(long var0) throws JRDFoxException;

    protected static native void nRecomputeMaterialization(long var0) throws JRDFoxException;

    protected static native void nCreateExplanation(long var0, String var2, int var3, int var4, int var5, OutputStream var6) throws JRDFoxException;

    protected static native String[] nCreateCursor(long var0, String var2, String[] var3, int var4, long[] var5) throws JRDFoxException;

    protected static native StatementResult nEvaluateQuery(long var0, String var2, String[] var3, JRDFoxQueryAnswerMonitor var4) throws JRDFoxException;

    protected static native StatementResult nEvaluateUpdate(long var0, String var2, String[] var3) throws JRDFoxException;

    protected static native StatementResult nEvaluateStatementStream(long var0, String var2, String[] var3, OutputStream var4, String var5) throws JRDFoxException;

    protected static native StatementResult nEvaluateStatementFile(long var0, String var2, String[] var3, String var4, String var5) throws JRDFoxException;

    protected final void markUsedEnsureValid() throws JRDFoxException {
        if (this.m_inUse.compareAndExchangeAcquire(false, true)) {
            throw new JRDFoxException("An operation (most likely initiated from another thread) is currently active on this data store connection.");
        }
        if (this.m_dataStoreConnectionPtr == 0L) {
            this.m_inUse.setRelease(false);
            throw new JRDFoxException("This data store connection has been closed.");
        }
    }

    protected final void markUnused() {
        this.m_inUse.setRelease(false);
    }

    protected JRDFoxDataStoreConnection(String string, long l) throws JRDFoxException {
        this.m_name = string;
        this.m_dataStoreConnectionPtr = l;
        this.m_resourceValueCache = new JRDFoxResourceValueCache();
        String[] stringArray = new String[1];
        boolean[] blArray = new boolean[1];
        String[] stringArray2 = JRDFoxDataStoreConnection.nDescribeDataStore(this.m_dataStoreConnectionPtr, stringArray, blArray);
        this.m_uniqueID = stringArray[0];
        this.m_isPersistent = blArray[0];
        this.m_parameters = Collections.unmodifiableMap(JRDFoxServer.stringArrayToMap(stringArray2, 0));
        this.m_inUse = new AtomicBoolean(false);
        this.m_numberOfCursors = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.m_inUse.compareAndExchangeAcquire(false, true)) {
            throw new IllegalStateException("The data store connection could not be closed because an operation on this connection (most likely initiated from another thread) is already in progress. Using data store connections on multiple threads simultaneously is not supported (other than as mentioned in the documentation), so this is a bug in the code using RDFox.");
        }
        JRDFoxDataStoreConnection jRDFoxDataStoreConnection = this;
        synchronized (jRDFoxDataStoreConnection) {
            if (this.m_numberOfCursors != 0) {
                this.m_inUse.setRelease(false);
                throw new IllegalStateException("The data store connection could not be closed because not all cursors created on this connection have been closed. Deleting a connection without closing all cursors would lead to a crash, so this is a bug in the code using RDFox.");
            }
            if (this.m_dataStoreConnectionPtr != 0L) {
                JRDFoxDataStoreConnection.nClose(this.m_dataStoreConnectionPtr);
                this.m_dataStoreConnectionPtr = 0L;
            }
        }
        this.m_inUse.setRelease(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() throws JRDFoxException {
        JRDFoxDataStoreConnection jRDFoxDataStoreConnection = this;
        synchronized (jRDFoxDataStoreConnection) {
            if (this.m_dataStoreConnectionPtr == 0L) {
                throw new JRDFoxException("This data store connection has been closed.");
            }
            JRDFoxDataStoreConnection.nInterrupt(this.m_dataStoreConnectionPtr);
        }
    }

    @Override
    public String getAgentName() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            String string = JRDFoxDataStoreConnection.nGetAgentName(this.m_dataStoreConnectionPtr);
            return string;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public long getLockTimeout() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            long l = JRDFoxDataStoreConnection.nGetLockTimeout(this.m_dataStoreConnectionPtr);
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void setLockTimeout(long l) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nSetLockTimeout(this.m_dataStoreConnectionPtr, l);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public DataStoreOperationStartMonitor getDataStoreOperationStartMonitor() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            DataStoreOperationStartMonitor dataStoreOperationStartMonitor = JRDFoxDataStoreConnection.nGetDataStoreOperationStartMonitor(this.m_dataStoreConnectionPtr);
            return dataStoreOperationStartMonitor;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void setDataStoreOperationStartMonitor(DataStoreOperationStartMonitor dataStoreOperationStartMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nSetDataStoreOperationStartMonitor(this.m_dataStoreConnectionPtr, dataStoreOperationStartMonitor);
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStoreConnection duplicate() throws JRDFoxException {
        long l;
        JRDFoxDataStoreConnection jRDFoxDataStoreConnection = this;
        synchronized (jRDFoxDataStoreConnection) {
            if (this.m_dataStoreConnectionPtr == 0L) {
                throw new JRDFoxException("This data store connection has been closed.");
            }
            l = JRDFoxDataStoreConnection.nDuplicate(this.m_dataStoreConnectionPtr);
        }
        try {
            return new JRDFoxDataStoreConnection(this.m_name, l);
        }
        catch (Throwable throwable) {
            JRDFoxDataStoreConnection.nClose(l);
            if (throwable instanceof JRDFoxException) {
                throw (JRDFoxException)throwable;
            }
            throw new JRDFoxException("Error while duplicating the connection.", throwable);
        }
    }

    @Override
    public String getName() throws JRDFoxException {
        return this.m_name;
    }

    @Override
    public String getUniqueID() throws JRDFoxException {
        return this.m_uniqueID;
    }

    @Override
    public boolean isPersistent() throws JRDFoxException {
        return this.m_isPersistent;
    }

    @Override
    public Map<String, String> getParameters() throws JRDFoxException {
        return this.m_parameters;
    }

    @Override
    public ComponentInfo getComponentInfo(boolean bl) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            ComponentInfo componentInfo = JRDFoxDataStoreConnection.nGetComponentInfo(this.m_dataStoreConnectionPtr, bl);
            return componentInfo;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public Map<String, String> getDataStoreProperties() throws JRDFoxException {
        String[] stringArray;
        this.markUsedEnsureValid();
        try {
            stringArray = JRDFoxDataStoreConnection.nGetDataStoreProperties(this.m_dataStoreConnectionPtr);
        }
        finally {
            this.markUnused();
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            linkedHashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return linkedHashMap;
    }

    @Override
    public String getDataStoreProperty(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            String string2 = JRDFoxDataStoreConnection.nGetDataStoreProperty(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the property cannot be null."));
            return string2;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDataStoreProperty(String string, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nSetDataStoreProperty(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the property cannot be null."), Objects.requireNonNull(string2, "The property value cannot be null."));
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public Prefixes getPrefixes() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            Prefixes prefixes = JRDFoxDataStoreConnection.nGetPrefixes(this.m_dataStoreConnectionPtr);
            return prefixes;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean setPrefixes(Prefixes prefixes) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nSetPrefixes(this.m_dataStoreConnectionPtr, prefixes);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPrefix(String string, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nSetPrefix(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The prefix name cannot be null."), Objects.requireNonNull(string2, "The prefix IRI cannot be null."));
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean unsetPrefix(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nUnsetPrefix(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The prefix name cannot be null."));
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public Map<String, Optional<DataSourceInfo>> listDataSources() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            Map<String, Optional<DataSourceInfo>> map = JRDFoxDataStoreConnection.nListDataSources(this.m_dataStoreConnectionPtr);
            return map;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean containsDataSource(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nContainsDataSource(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the data source cannot be null."));
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public DataSourceInfo describeDataSource(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            DataSourceInfo dataSourceInfo = JRDFoxDataStoreConnection.nDescribeDataSource(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the data source cannot be null."));
            return dataSourceInfo;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void registerDataSource(String string, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nRegisterDataSource(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the data source cannot be null."), JRDFoxServer.mapToStringArray(map));
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void deregisterDataSource(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nDeregisterDataSource(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the data source cannot be null."));
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public List<DataSourceTableInfo> listDataSourceTables(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            List<DataSourceTableInfo> list = Arrays.asList(JRDFoxDataStoreConnection.nListDataSourceTables(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the data source cannot be null.")));
            return list;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsDataSourceTable(String string, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nContainsDataSourceTable(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the data source cannot be null."), Objects.requireNonNull(string2, "The name of the data source table cannot be null."));
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSourceTableInfo describeDataSourceTable(String string, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            DataSourceTableInfo dataSourceTableInfo = JRDFoxDataStoreConnection.nDescribeDataSourceTable(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the data source cannot be null."), Objects.requireNonNull(string2, "The name of the data source table cannot be null."));
            return dataSourceTableInfo;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceValue[][] getDataSourceTableData(String string, String string2, int n) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            Object[] objectArray = JRDFoxDataStoreConnection.nGetDataSourceTableData(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the data source cannot be null."), Objects.requireNonNull(string2, "The name of the data source table cannot be null."), n);
            int[] nArray = (int[])objectArray[0];
            String[] stringArray = (String[])objectArray[1];
            short[] sArray = (short[])objectArray[2];
            int n2 = nArray.length;
            ResourceValue[][] resourceValueArray = new ResourceValue[n2][];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = nArray[i];
                ResourceValue[] resourceValueArray2 = new ResourceValue[n4];
                for (int j = 0; j < n4; ++j) {
                    resourceValueArray2[j] = new JRDFoxResourceValue(stringArray[n3], Datatype.value(sArray[n3]));
                    ++n3;
                }
                resourceValueArray[i] = resourceValueArray2;
            }
            ResourceValue[][] resourceValueArray3 = resourceValueArray;
            return resourceValueArray3;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public Map<String, Optional<TupleTableInfo>> listTupleTables() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            Map<String, Optional<TupleTableInfo>> map = JRDFoxDataStoreConnection.nListTupleTables(this.m_dataStoreConnectionPtr);
            return map;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean containsTupleTable(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nContainsTupleTable(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the tuple table cannot be null."));
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public TupleTableInfo describeTupleTable(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            TupleTableInfo tupleTableInfo = JRDFoxDataStoreConnection.nDescribeTupleTable(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the tuple table cannot be null."));
            return tupleTableInfo;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void createTupleTable(String string, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nCreateTupleTable(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the tuple table cannot be null."), JRDFoxServer.mapToStringArray(map));
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void deleteTupleTable(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nDeleteTupleTable(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the tuple table cannot be null."));
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public List<StatisticsInfo> listStatistics() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            List<StatisticsInfo> list = Arrays.asList(JRDFoxDataStoreConnection.nListStatistics(this.m_dataStoreConnectionPtr));
            return list;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean containsStatistics(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nContainsStatistics(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the statistics cannot be null."));
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public StatisticsInfo describeStatistics(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            StatisticsInfo statisticsInfo = JRDFoxDataStoreConnection.nDescribeStatistics(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the statistics cannot be null."));
            return statisticsInfo;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void createStatistics(String string, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nCreateStatistics(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the statistics cannot be null."), JRDFoxServer.mapToStringArray(map));
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void deleteStatistics(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nDeleteStatistics(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the statistics cannot be null."));
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void updateStatistics() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nUpdateStatisticsAll(this.m_dataStoreConnectionPtr);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void updateStatistics(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nUpdateStatisticsOne(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the statistics cannot be null."));
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public long getDataStoreVersionAfterLastOperation() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            long l = JRDFoxDataStoreConnection.nGetDataStoreVersionAfterLastOperation(this.m_dataStoreConnectionPtr);
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public long getDataStoreVersion() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            long l = JRDFoxDataStoreConnection.nGetDataStoreVersion(this.m_dataStoreConnectionPtr);
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public long getLastSnapshotDataStoreVersion() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            long l = JRDFoxDataStoreConnection.nGetLastSnapshotDataStoreVersion(this.m_dataStoreConnectionPtr);
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public CommitProcedureInfo getCommitProcedure() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            CommitProcedureInfo commitProcedureInfo = JRDFoxDataStoreConnection.nGetCommitProcedure(this.m_dataStoreConnectionPtr);
            return commitProcedureInfo;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean setCommitProcedure(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nSetCommitProcedure(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The commit procedure cannot be null."));
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCommitProcedure(List<Update> list) throws JRDFoxException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Update update : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(" ; ");
            }
            update.toString(Prefixes.s_emptyPrefixes, stringBuilder);
        }
        this.markUsedEnsureValid();
        try {
            boolean bl2 = JRDFoxDataStoreConnection.nSetCommitProcedure(this.m_dataStoreConnectionPtr, stringBuilder.toString());
            return bl2;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public Map<String, Optional<DeltaQueryInfo>> listDeltaQueries() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            Map<String, Optional<DeltaQueryInfo>> map = JRDFoxDataStoreConnection.nListDeltaQueries(this.m_dataStoreConnectionPtr);
            return map;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean containsDeltaQuery(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nContainsDeltaQuery(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the delta query cannot be null."));
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public DeltaQueryInfo describeDeltaQuery(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            DeltaQueryInfo deltaQueryInfo = JRDFoxDataStoreConnection.nDescribeDeltaQuery(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the delta query cannot be null."));
            return deltaQueryInfo;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDeltaQuery(String string, String string2, String string3, long l, long l2, long l3) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nRegisterDeltaQuery(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the delta query cannot be null."), Objects.requireNonNull(string2, "The query text cannot be null."), Objects.requireNonNull(string3, "The format name cannot be null."), l, l2, l3);
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDeltaQuery(String string, Query query, String string2, long l, long l2, long l3) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nRegisterDeltaQuery(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the delta query cannot be null."), query.toString(Prefixes.s_emptyPrefixes), Objects.requireNonNull(string2, "The format name cannot be null."), l, l2, l3);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void deregisterDeltaQuery(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nDeregisterDeltaQuery(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the delta query cannot be null."));
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void setDeltaQueryEvaluationMode(String string, DeltaQueryEvaluationMode deltaQueryEvaluationMode) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nSetDeltaQueryEvaluationMode(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The name of the delta query cannot be null."), deltaQueryEvaluationMode.ordinal());
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DeltaQueryAnswerInfo> listDeltaQueryAnswers(Optional<String> optional, Optional<Long> optional2, Optional<Long> optional3, Optional<DeltaQueryAnswerType> optional4) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            List<DeltaQueryAnswerInfo> list = Arrays.asList(JRDFoxDataStoreConnection.nListDeltaQueryAnswers(this.m_dataStoreConnectionPtr, optional, optional2, optional3, optional4.isPresent() ? Optional.of(optional4.get().ordinal()) : Optional.empty()));
            return list;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long deleteDeltaQueryAnswers(Optional<String> optional, Optional<Long> optional2, Optional<Long> optional3, Optional<DeltaQueryAnswerType> optional4) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            long l = JRDFoxDataStoreConnection.nDeleteDeltaQueryAnswers(this.m_dataStoreConnectionPtr, optional, optional2, optional3, optional4.isPresent() ? Optional.of(optional4.get().ordinal()) : Optional.empty());
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportDeltaQueryAnswer(OutputStream outputStream, String string, long l, DeltaQueryAnswerType deltaQueryAnswerType) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nExportDeltaQueryAnswer(this.m_dataStoreConnectionPtr, outputStream, Objects.requireNonNull(string, "The name of the delta query cannot be null."), l, deltaQueryAnswerType.ordinal());
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public TransactionState getTransactionState() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            int n = JRDFoxDataStoreConnection.nGetTransactionState(this.m_dataStoreConnectionPtr);
            TransactionState transactionState = TransactionState.values()[n];
            return transactionState;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean transactionRequiresRollback() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nTransactionRequiresRollback(this.m_dataStoreConnectionPtr);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void beginTransaction(TransactionType transactionType) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nBeginTransaction(this.m_dataStoreConnectionPtr, transactionType.ordinal());
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void commitTransaction() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nCommitTransaction(this.m_dataStoreConnectionPtr);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void rollbackTransaction() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nRollbackTransaction(this.m_dataStoreConnectionPtr);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void compact() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nCompact(this.m_dataStoreConnectionPtr);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void clear(int n) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nClear(this.m_dataStoreConnectionPtr, n);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void clearRulesAxiomsExplicateFacts() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nClearRulesAxiomsExplicateFacts(this.m_dataStoreConnectionPtr);
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportData(OutputStream outputStream, String string, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nExportDataStream(this.m_dataStoreConnectionPtr, outputStream, Objects.requireNonNull(string, "The name of the format cannot be null."), JRDFoxServer.mapToStringArray(map));
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportData(File file, String string, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nExportDataFile(this.m_dataStoreConnectionPtr, file.getAbsolutePath(), null, null, Objects.requireNonNull(string, "The name of the format cannot be null."), JRDFoxServer.mapToStringArray(map));
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportData(File file, String string, String string2, String string3, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nExportDataFile(this.m_dataStoreConnectionPtr, file.getAbsolutePath(), string, string2, Objects.requireNonNull(string3, "The name of the format cannot be null."), JRDFoxServer.mapToStringArray(map));
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportResult importData(UpdateType updateType, InputSourceFactory inputSourceFactory, String string, ImportNotificationMonitor importNotificationMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            ImportResult importResult = JRDFoxDataStoreConnection.nImportDataOne(this.m_dataStoreConnectionPtr, "UNDEF", Datatype.INVALID_DATATYPE.getDatatypeID(), updateType.getValue(), inputSourceFactory, Objects.requireNonNull(string, "The name of the format cannot be null."), importNotificationMonitor);
            return importResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportResult importData(UpdateType updateType, Collection<InputSourceFactory> collection, String string, ImportNotificationMonitor importNotificationMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            ImportResult importResult = JRDFoxDataStoreConnection.nImportDataMany(this.m_dataStoreConnectionPtr, "UNDEF", Datatype.INVALID_DATATYPE.getDatatypeID(), updateType.getValue(), collection.toArray(new InputSourceFactory[collection.size()]), Objects.requireNonNull(string, "The name of the format cannot be null."), importNotificationMonitor);
            return importResult;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public ImportResult importData(UpdateType updateType, File file) throws JRDFoxException {
        return this.importData(ResourceValue.UNDEF, updateType, file);
    }

    @Override
    public ImportResult importData(UpdateType updateType, String string) throws JRDFoxException {
        return this.importData(ResourceValue.UNDEF, updateType, string);
    }

    @Override
    public ImportResult importData(UpdateType updateType, InputStream inputStream) throws JRDFoxException {
        return this.importData(ResourceValue.UNDEF, updateType, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportResult importData(ResourceValue resourceValue, UpdateType updateType, InputSourceFactory inputSourceFactory, String string, ImportNotificationMonitor importNotificationMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            ImportResult importResult = JRDFoxDataStoreConnection.nImportDataOne(this.m_dataStoreConnectionPtr, resourceValue.getLexicalForm(), resourceValue.getDatatype().getDatatypeID(), updateType.getValue(), inputSourceFactory, Objects.requireNonNull(string, "The name of the format cannot be null."), importNotificationMonitor);
            return importResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportResult importData(ResourceValue resourceValue, UpdateType updateType, Collection<InputSourceFactory> collection, String string, ImportNotificationMonitor importNotificationMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            ImportResult importResult = JRDFoxDataStoreConnection.nImportDataMany(this.m_dataStoreConnectionPtr, resourceValue.getLexicalForm(), resourceValue.getDatatype().getDatatypeID(), updateType.getValue(), collection.toArray(new InputSourceFactory[collection.size()]), Objects.requireNonNull(string, "The name of the format cannot be null."), importNotificationMonitor);
            return importResult;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public ImportResult importData(ResourceValue resourceValue, UpdateType updateType, File file) throws JRDFoxException {
        return this.importData(resourceValue, updateType, InputSourceFactory.newInputSourceFactory(file), GUESS_FORMAT_NAME, ImportNotificationMonitor.s_firstErrorExceptionMonitor);
    }

    @Override
    public ImportResult importData(ResourceValue resourceValue, UpdateType updateType, String string) throws JRDFoxException {
        return this.importData(resourceValue, updateType, InputSourceFactory.newInputSourceFactory("string", "https://rdfox.com/default-base-iri/", string), GUESS_FORMAT_NAME, ImportNotificationMonitor.s_firstErrorExceptionMonitor);
    }

    @Override
    public ImportResult importData(ResourceValue resourceValue, UpdateType updateType, InputStream inputStream) throws JRDFoxException {
        return this.importData(resourceValue, updateType, InputSourceFactory.newInputSourceFactory("stream", "https://rdfox.com/default-base-iri/", inputStream), GUESS_FORMAT_NAME, ImportNotificationMonitor.s_firstErrorExceptionMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportResult importAxiomsFromTriples(ResourceValue resourceValue, boolean bl, ResourceValue resourceValue2, UpdateType updateType, ImportNotificationMonitor importNotificationMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            ImportResult importResult = JRDFoxDataStoreConnection.nImportAxiomsFromTriples(this.m_dataStoreConnectionPtr, resourceValue.getLexicalForm(), resourceValue.getDatatype().getDatatypeID(), bl, resourceValue2.getLexicalForm(), resourceValue2.getDatatype().getDatatypeID(), updateType.getValue(), importNotificationMonitor);
            return importResult;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public ImportResult importAxiomsFromTriples(ResourceValue resourceValue, boolean bl, ResourceValue resourceValue2, UpdateType updateType) throws JRDFoxException {
        return this.importAxiomsFromTriples(resourceValue, bl, resourceValue2, updateType, ImportNotificationMonitor.s_firstErrorExceptionMonitor);
    }

    @Override
    public List<RuleInfo> listRules() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            List<RuleInfo> list = Arrays.asList(JRDFoxDataStoreConnection.nListRules(this.m_dataStoreConnectionPtr));
            return list;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addRule(Rule rule) throws JRDFoxException {
        StringBuilder stringBuilder = new StringBuilder();
        rule.toString(Prefixes.s_emptyPrefixes, stringBuilder);
        this.markUsedEnsureValid();
        try {
            long l = JRDFoxDataStoreConnection.nAddDeleteRules(this.m_dataStoreConnectionPtr, UpdateType.ADDITION.getValue(), stringBuilder.toString());
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addRules(Collection<Rule> collection) throws JRDFoxException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Rule rule : collection) {
            rule.toString(Prefixes.s_emptyPrefixes, stringBuilder);
            stringBuilder.append('\n');
        }
        this.markUsedEnsureValid();
        try {
            long l = JRDFoxDataStoreConnection.nAddDeleteRules(this.m_dataStoreConnectionPtr, UpdateType.ADDITION.getValue(), stringBuilder.toString());
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long deleteRule(Rule rule) throws JRDFoxException {
        StringBuilder stringBuilder = new StringBuilder();
        rule.toString(Prefixes.s_emptyPrefixes, stringBuilder);
        this.markUsedEnsureValid();
        try {
            long l = JRDFoxDataStoreConnection.nAddDeleteRules(this.m_dataStoreConnectionPtr, UpdateType.DELETION.getValue(), stringBuilder.toString());
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long deleteRules(Collection<Rule> collection) throws JRDFoxException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Rule rule : collection) {
            rule.toString(Prefixes.s_emptyPrefixes, stringBuilder);
            stringBuilder.append('\n');
        }
        this.markUsedEnsureValid();
        try {
            long l = JRDFoxDataStoreConnection.nAddDeleteRules(this.m_dataStoreConnectionPtr, UpdateType.DELETION.getValue(), stringBuilder.toString());
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void recompile() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nRecompile(this.m_dataStoreConnectionPtr);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean getIncrementalReasoningAllowed() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = JRDFoxDataStoreConnection.nGetIncrementalReasoningAllowed(this.m_dataStoreConnectionPtr);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void setIncrementalReasoningAllowed(boolean bl) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nSetIncrementalReasoningAllowed(this.m_dataStoreConnectionPtr, bl);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public ReasoningAlgorithm getDataStoreReasoningAlgorithm() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            ReasoningAlgorithm reasoningAlgorithm = ReasoningAlgorithm.values()[JRDFoxDataStoreConnection.nGetDataStoreReasoningAlgorithm(this.m_dataStoreConnectionPtr)];
            return reasoningAlgorithm;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void updateMaterialization() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nUpdateMaterialization(this.m_dataStoreConnectionPtr);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void recomputeMaterialization() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nRecomputeMaterialization(this.m_dataStoreConnectionPtr);
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createExplanation(String string, int n, int n2, ExplanationType explanationType, OutputStream outputStream) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            JRDFoxDataStoreConnection.nCreateExplanation(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The text of the fact cannot be null."), n, n2, explanationType.ordinal(), outputStream);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void createExplanation(TupleTableAtom tupleTableAtom, int n, int n2, ExplanationType explanationType, OutputStream outputStream) throws JRDFoxException {
        this.createExplanation(tupleTableAtom.toString(Prefixes.s_emptyPrefixes), n, n2, explanationType, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor createCursor(String string, Map<String, String> map, int n) throws JRDFoxException {
        String[] stringArray;
        if (n <= 0) {
            throw new JRDFoxException("The fetch window size must be larger than zero.");
        }
        long[] lArray = new long[6];
        this.markUsedEnsureValid();
        try {
            stringArray = JRDFoxDataStoreConnection.nCreateCursor(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The text of the query cannot be null."), JRDFoxServer.mapToStringArray(map), n, lArray);
        }
        finally {
            this.markUnused();
        }
        try {
            return new JRDFoxCursor(this, lArray[0], lArray[1], CursorType.values()[(int)lArray[2]], (int)lArray[3], stringArray, lArray[4], lArray[5], n);
        }
        catch (Throwable throwable) {
            JRDFoxCursor.nClose(lArray[0], lArray[4]);
            if (throwable instanceof JRDFoxException) {
                throw (JRDFoxException)throwable;
            }
            throw new JRDFoxException("Error while duplicating the connection.", throwable);
        }
    }

    @Override
    public Cursor createCursor(String string, Map<String, String> map) throws JRDFoxException {
        return this.createCursor(string, map, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor createCursor(Query query, Map<String, String> map, int n) throws JRDFoxException {
        String[] stringArray;
        if (n <= 0) {
            throw new JRDFoxException("The fetch window size must be larger than zero.");
        }
        long[] lArray = new long[6];
        this.markUsedEnsureValid();
        try {
            stringArray = JRDFoxDataStoreConnection.nCreateCursor(this.m_dataStoreConnectionPtr, query.toString(Prefixes.s_emptyPrefixes), JRDFoxServer.mapToStringArray(map), n, lArray);
        }
        finally {
            this.markUnused();
        }
        try {
            return new JRDFoxCursor(this, lArray[0], lArray[1], CursorType.values()[(int)lArray[2]], (int)lArray[3], stringArray, lArray[4], lArray[5], n);
        }
        catch (Throwable throwable) {
            JRDFoxCursor.nClose(lArray[0], lArray[4]);
            if (throwable instanceof JRDFoxException) {
                throw (JRDFoxException)throwable;
            }
            throw new JRDFoxException("Error while duplicating the connection.", throwable);
        }
    }

    @Override
    public Cursor createCursor(Query query, Map<String, String> map) throws JRDFoxException {
        return this.createCursor(query, map, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementResult evaluateQuery(String string, Map<String, String> map, QueryAnswerMonitor queryAnswerMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            StatementResult statementResult = JRDFoxDataStoreConnection.nEvaluateQuery(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The query text cannot be null."), JRDFoxServer.mapToStringArray(map), new JRDFoxQueryAnswerMonitor(this.m_resourceValueCache, queryAnswerMonitor));
            return statementResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementResult evaluateQuery(Query query, Map<String, String> map, QueryAnswerMonitor queryAnswerMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            StatementResult statementResult = JRDFoxDataStoreConnection.nEvaluateQuery(this.m_dataStoreConnectionPtr, query.toString(Prefixes.s_emptyPrefixes), JRDFoxServer.mapToStringArray(map), new JRDFoxQueryAnswerMonitor(this.m_resourceValueCache, queryAnswerMonitor));
            return statementResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementResult evaluateUpdate(String string, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            StatementResult statementResult = JRDFoxDataStoreConnection.nEvaluateUpdate(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The update text cannot be null."), JRDFoxServer.mapToStringArray(map));
            return statementResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementResult evaluateUpdate(Update update, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            StatementResult statementResult = JRDFoxDataStoreConnection.nEvaluateUpdate(this.m_dataStoreConnectionPtr, update.toString(Prefixes.s_emptyPrefixes), JRDFoxServer.mapToStringArray(map));
            return statementResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementResult evaluateUpdates(List<Update> list, Map<String, String> map) throws JRDFoxException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Update update : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(" ; ");
            }
            update.toString(Prefixes.s_emptyPrefixes, stringBuilder);
        }
        this.markUsedEnsureValid();
        try {
            StatementResult statementResult = JRDFoxDataStoreConnection.nEvaluateUpdate(this.m_dataStoreConnectionPtr, stringBuilder.toString(), JRDFoxServer.mapToStringArray(map));
            return statementResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementResult evaluateStatement(String string, Map<String, String> map, OutputStream outputStream, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            StatementResult statementResult = JRDFoxDataStoreConnection.nEvaluateStatementStream(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The statement text cannot be null."), JRDFoxServer.mapToStringArray(map), outputStream, string2);
            return statementResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementResult evaluateStatement(Statement statement, Map<String, String> map, OutputStream outputStream, String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            StatementResult statementResult = JRDFoxDataStoreConnection.nEvaluateStatementStream(this.m_dataStoreConnectionPtr, statement.toString(Prefixes.s_emptyPrefixes), JRDFoxServer.mapToStringArray(map), outputStream, string);
            return statementResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementResult evaluateStatement(String string, Map<String, String> map, File file, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            StatementResult statementResult = JRDFoxDataStoreConnection.nEvaluateStatementFile(this.m_dataStoreConnectionPtr, Objects.requireNonNull(string, "The statement text cannot be null."), JRDFoxServer.mapToStringArray(map), file.getAbsolutePath(), string2);
            return statementResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementResult evaluateStatement(Statement statement, Map<String, String> map, File file, String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            StatementResult statementResult = JRDFoxDataStoreConnection.nEvaluateStatementFile(this.m_dataStoreConnectionPtr, statement.toString(Prefixes.s_emptyPrefixes), JRDFoxServer.mapToStringArray(map), file.getAbsolutePath(), string);
            return statementResult;
        }
        finally {
            this.markUnused();
        }
    }
}

