/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.io;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class CipherInputStream
extends InputStream {
    protected static final int s_headerSize = 2;
    protected final InputStream m_inputStream;
    protected final Cipher m_cipher;
    protected final int m_cipherBlockSize;
    protected final int m_cipherBlockSizeMinusOne;
    protected final int m_inputBlockSize;
    protected final byte[] m_inputBlock;
    protected int m_dataCurrentIndex;
    protected int m_dataEndIndex;

    public CipherInputStream(InputStream inputStream) throws IOException {
        this.m_inputStream = inputStream;
        try {
            this.m_cipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new IOException(generalSecurityException);
        }
        this.m_cipherBlockSize = this.m_cipher.getBlockSize();
        if (this.m_cipherBlockSize > 256) {
            throw new IOException("The cipher block size of " + this.m_cipherBlockSize + " bytes is not supported.");
        }
        this.m_cipherBlockSizeMinusOne = this.m_cipherBlockSize - 1;
        this.m_inputBlockSize = 65535 / this.m_cipherBlockSize * this.m_cipherBlockSize;
        this.m_inputBlock = new byte[2 + this.m_inputBlockSize];
        this.m_dataEndIndex = 2;
        this.m_dataCurrentIndex = 2;
    }

    protected boolean readExactlyFromStream(byte[] byArray, int n, int n2, String string) throws IOException {
        int n3 = this.m_inputStream.read(byArray, n, n2);
        if (n3 == -1) {
            return false;
        }
        do {
            if (n3 != n2) continue;
            return true;
        } while ((n3 = this.m_inputStream.read(byArray, n += n3, n2 -= n3)) != -1);
        throw new IOException(string);
    }

    public boolean initialize(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException, IOException {
        int n = 16;
        byte[] byArray = new byte[n];
        if (!this.readExactlyFromStream(byArray, 0, n, "Incomplete IV.")) {
            return false;
        }
        this.m_cipher.init(2, key, new IvParameterSpec(byArray));
        return true;
    }

    protected void readInputBlock() throws IOException {
        if (this.readExactlyFromStream(this.m_inputBlock, 0, 2, "Incomplete encrypted block header.")) {
            int n = (this.m_inputBlock[1] & 0xFF) << 8 | this.m_inputBlock[0] & 0xFF;
            if (n == 0) {
                throw new IOException("Invalid data size in the encrypted block header.");
            }
            int n2 = (n + this.m_cipherBlockSizeMinusOne) / this.m_cipherBlockSize * this.m_cipherBlockSize;
            if (n2 > this.m_inputBlockSize) {
                throw new IOException("Invalid data size in the encrypted block header.");
            }
            if (!this.readExactlyFromStream(this.m_inputBlock, 2, n2, "Incomplete encrypted block data.")) {
                throw new IOException("Incomplete encrypted block data.");
            }
            try {
                int n3 = this.m_cipher.update(this.m_inputBlock, 2, n2, this.m_inputBlock, 2);
                if (n3 != n2) {
                    throw new IOException("Decryption returned a block of size " + n3 + ", which is different from the padded size of " + n2 + ".");
                }
            }
            catch (ShortBufferException shortBufferException) {
                throw new IOException("Cipher input stream decryption call failed.", shortBufferException);
            }
            this.m_dataEndIndex = 2 + n;
        } else {
            this.m_dataEndIndex = 2;
        }
        this.m_dataCurrentIndex = 2;
    }

    @Override
    public int read() throws IOException {
        if (this.m_dataCurrentIndex == this.m_dataEndIndex) {
            this.readInputBlock();
            if (this.m_dataCurrentIndex == this.m_dataEndIndex) {
                return -1;
            }
        }
        byte by = this.m_inputBlock[this.m_dataCurrentIndex];
        ++this.m_dataCurrentIndex;
        return by;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.m_dataCurrentIndex == this.m_dataEndIndex) {
            this.readInputBlock();
            if (this.m_dataCurrentIndex == this.m_dataEndIndex) {
                return -1;
            }
        }
        int n3 = Math.min(this.m_dataEndIndex - this.m_dataCurrentIndex, n2);
        System.arraycopy(this.m_inputBlock, this.m_dataCurrentIndex, byArray, n, n3);
        this.m_dataCurrentIndex += n3;
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.m_inputStream.close();
    }
}

