/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.datalog;

import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.client.ResourceValue;
import tech.oxfordsemantic.jrdfox.formats.internal.TurtleSyntax;
import tech.oxfordsemantic.jrdfox.logic.LogicObject;
import tech.oxfordsemantic.jrdfox.logic.LogicVisitor;
import tech.oxfordsemantic.jrdfox.util.InterningManager;

public class TupleTableName
extends LogicObject {
    protected final String m_name;
    private static final long serialVersionUID = 4663759472676779435L;
    protected static final int s_classHashCodeTimes31 = 31 * TupleTableName.class.hashCode();
    protected static InterningManager.Creator s_creator = new InterningManager.Creator(){

        @Override
        public InterningManager.InternedObject create(Object object) {
            return new TupleTableName((String)object);
        }
    };
    public static final TupleTableName[] EMPTY_ARRAY = new TupleTableName[0];
    public static final TupleTableName DEFAULT_TRIPLES = TupleTableName.create("DefaultTriples");
    public static final TupleTableName QUADS = TupleTableName.create("Quads");
    public static final TupleTableName DEPENDENCY_GRAPH = TupleTableName.create("DependencyGraph");
    public static final TupleTableName DEPENDENCY_GRAPH_D = TupleTableName.create("DependencyGraph_D");
    public static final TupleTableName DEPENDENCY_GRAPH_N = TupleTableName.create("DependencyGraph_N");
    public static final TupleTableName SKOLEM = TupleTableName.create("SKOLEM");
    public static final TupleTableName SHACL = TupleTableName.create("SHACL");
    public static final TupleTableName SHACL_DD = TupleTableName.create("SHACL_DD");
    public static final TupleTableName SHACL_ND = TupleTableName.create("SHACL_ND");
    public static final TupleTableName SHACL_DN = TupleTableName.create("SHACL_DN");
    public static final TupleTableName SHACL_NN = TupleTableName.create("SHACL_NN");

    protected static boolean shouldQuoteTupleTableName(String string) {
        int n = string.length();
        if (n == 0 || string.equalsIgnoreCase("aggregate") || string.equalsIgnoreCase("bind") || string.equalsIgnoreCase("filter") || string.equalsIgnoreCase("not") || string.endsWith(".")) {
            return true;
        }
        int n2 = string.codePointAt(0);
        if (!TurtleSyntax.is_PN_CHARS_BASE(n2)) {
            return true;
        }
        for (int i = Character.charCount(n2); i < n; i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            if (TurtleSyntax.is_PN_CHARS_DOT(n2)) continue;
            return true;
        }
        return false;
    }

    protected static void printTupleTableName(Consumer<String> consumer, String string) {
        if (TupleTableName.shouldQuoteTupleTableName(string)) {
            ResourceValue.appendString(consumer, string, string.length());
        } else {
            consumer.accept(string);
        }
    }

    protected TupleTableName(String string) {
        this.m_name = string;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public <E> E accept(LogicVisitor<E> logicVisitor) {
        return logicVisitor.visit(this);
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        TupleTableName.printTupleTableName(consumer, this.m_name);
    }

    public static TupleTableName create(String string) {
        return InterningManager.s_instance.intern(TupleTableName.hashCode(s_classHashCodeTimes31, string), TupleTableName.class, s_creator, string);
    }

    @Override
    protected boolean interningEquals(Class<?> clazz, Object object) {
        return clazz == TupleTableName.class && this.m_name.equals(object);
    }

    protected Object readResolve() {
        return TupleTableName.create(this.m_name);
    }
}

