/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.exceptions.ParsingException;
import tech.oxfordsemantic.jrdfox.formats.InputConsumer;
import tech.oxfordsemantic.jrdfox.formats.internal.AbstractParser;
import tech.oxfordsemantic.jrdfox.formats.internal.CommonTokenizer;
import tech.oxfordsemantic.jrdfox.formats.internal.InputSource;
import tech.oxfordsemantic.jrdfox.logic.datalog.Aggregate;
import tech.oxfordsemantic.jrdfox.logic.datalog.Atom;
import tech.oxfordsemantic.jrdfox.logic.datalog.BindAtom;
import tech.oxfordsemantic.jrdfox.logic.datalog.BodyFormula;
import tech.oxfordsemantic.jrdfox.logic.datalog.FilterAtom;
import tech.oxfordsemantic.jrdfox.logic.datalog.Negation;
import tech.oxfordsemantic.jrdfox.logic.datalog.Rule;
import tech.oxfordsemantic.jrdfox.logic.datalog.TupleTableAtom;
import tech.oxfordsemantic.jrdfox.logic.datalog.TupleTableName;
import tech.oxfordsemantic.jrdfox.logic.expression.Expression;
import tech.oxfordsemantic.jrdfox.logic.expression.FunctionCall;
import tech.oxfordsemantic.jrdfox.logic.expression.IRI;
import tech.oxfordsemantic.jrdfox.logic.expression.Literal;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;
import tech.oxfordsemantic.jrdfox.logic.expression.Term;
import tech.oxfordsemantic.jrdfox.logic.expression.Variable;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.GroupGraphPattern;

public class DatalogParser
extends AbstractParser {
    protected final Resource m_defaultGraph;
    protected InputConsumer m_inputConsumer;

    public DatalogParser(Resource resource, String string, Prefixes prefixes) {
        this.m_baseIRI = URI.create(string);
        this.m_defaultGraph = resource;
        this.m_prefixes = prefixes;
    }

    @Override
    protected void prefixMappingParsed(String string, String string2) {
        this.m_inputConsumer.consumePrefixMapping(string, string2);
    }

    @Override
    protected GroupGraphPattern parseExistenceExpressionArgument() throws ParsingException {
        throw new ParsingException("[NOT] EXISTS is not supported in Datalog.");
    }

    protected FilterAtom parseFilterAtom() throws ParsingException, IOException {
        this.nextToken();
        Expression expression = this.parseConstraintExpression();
        return FilterAtom.create(expression);
    }

    protected BindAtom parseBindAtom() throws ParsingException, IOException {
        this.nextToken();
        if (!this.m_tokenizer.nonSymbolTokenEquals('(')) {
            throw new ParsingException("Expected '(' after 'BIND'.");
        }
        this.nextToken();
        Expression expression = this.parseConditionalOrExpression();
        if (!this.m_tokenizer.symbolLowerCaseTokenEquals("as")) {
            throw new ParsingException("Expected 'AS' after a bind expression.");
        }
        this.nextToken();
        Variable variable = this.parseVariable();
        if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
            throw new ParsingException("Expected ')' at the end of 'BIND'.");
        }
        this.nextToken();
        return BindAtom.create(expression, variable);
    }

    protected Atom parseAtom() throws ParsingException, IOException {
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("filter")) {
            return this.parseFilterAtom();
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("bind")) {
            return this.parseBindAtom();
        }
        return this.parseTupleTableAtom();
    }

    protected Negation parseNegation() throws ParsingException, IOException {
        this.nextToken();
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ArrayList<Atom> arrayList2 = new ArrayList<Atom>();
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("exist") || this.m_tokenizer.symbolLowerCaseTokenEquals("exists")) {
            this.nextToken();
            arrayList.add(this.parseVariable());
            while (this.m_tokenizer.nonSymbolTokenEquals(',')) {
                this.nextToken();
                arrayList.add(this.parseVariable());
            }
            if (!this.m_tokenizer.symbolLowerCaseTokenEquals("in")) {
                throw new ParsingException("Expected 'IN' after the existential variables in a 'NOT' atom.");
            }
            this.nextToken();
        }
        if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
            this.nextToken();
            arrayList2.add(this.parseAtom());
            while (this.m_tokenizer.nonSymbolTokenEquals(',')) {
                this.nextToken();
                arrayList2.add(this.parseAtom());
            }
            if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                throw new ParsingException("Expected ')' after the conjunction of a 'NOT' atom.");
            }
            this.nextToken();
        } else {
            arrayList2.add(this.parseAtom());
        }
        return Negation.create(arrayList, arrayList2);
    }

    protected Aggregate parseAggregate() throws ParsingException, IOException {
        this.nextToken();
        if (!this.m_tokenizer.nonSymbolTokenEquals('(')) {
            throw new ParsingException("Expected '(' after 'AGGREGATE'.");
        }
        this.nextToken();
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        arrayList.add(this.parseAtom());
        while (this.m_tokenizer.nonSymbolTokenEquals(',') || this.m_tokenizer.nonSymbolTokenEquals('&')) {
            this.nextToken();
            arrayList.add(this.parseAtom());
        }
        ArrayList<Variable> arrayList2 = new ArrayList<Variable>();
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("on")) {
            this.nextToken();
            while (this.m_tokenizer.isGood() && !this.m_tokenizer.symbolLowerCaseTokenEquals("bind") && !this.m_tokenizer.nonSymbolTokenEquals(')')) {
                arrayList2.add(this.parseVariable());
            }
        }
        ArrayList<Aggregate.Bind> arrayList3 = new ArrayList<Aggregate.Bind>();
        while (this.m_tokenizer.symbolLowerCaseTokenEquals("bind")) {
            this.nextToken();
            FunctionCall functionCall = this.parseFunctionCallExpression();
            if (!this.m_tokenizer.symbolLowerCaseTokenEquals("as")) {
                throw new ParsingException("Expected 'AS' after the aggregated expression.");
            }
            this.nextToken();
            Variable variable = this.parseVariable();
            arrayList3.add(new Aggregate.Bind(functionCall, variable));
        }
        if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
            throw new ParsingException("Expected ')' as termination of 'AGGREGATE'.");
        }
        this.nextToken();
        return Aggregate.create(arrayList, arrayList2, arrayList3);
    }

    protected BodyFormula parseBodyFormula() throws ParsingException, IOException {
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("not")) {
            return this.parseNegation();
        }
        if (this.m_tokenizer.symbolLowerCaseTokenEquals("aggregate")) {
            return this.parseAggregate();
        }
        return this.parseAtom();
    }

    protected void parseFactOrRule(int n, int n2) throws ParsingException, IOException {
        TupleTableAtom tupleTableAtom = this.parseTupleTableAtom();
        if (this.m_tokenizer.nonSymbolTokenEquals('.')) {
            this.m_tokenizer.nextToken();
            this.m_inputConsumer.consumeFact(n, n2, tupleTableAtom);
        } else {
            ArrayList<TupleTableAtom> arrayList = new ArrayList<TupleTableAtom>();
            arrayList.add(tupleTableAtom);
            while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals(":-")) {
                if (!this.m_tokenizer.nonSymbolTokenEquals(',') && !this.m_tokenizer.nonSymbolTokenEquals('&')) {
                    throw new ParsingException("Atoms in a rule head should be separated by ',' or by '&'.");
                }
                this.nextToken();
                arrayList.add(this.parseTupleTableAtom());
            }
            if (!this.m_tokenizer.nonSymbolTokenEquals(":-")) {
                throw new ParsingException("Expected ':-' in the rule.");
            }
            this.nextToken();
            ArrayList<BodyFormula> arrayList2 = new ArrayList<BodyFormula>();
            if (!this.m_tokenizer.nonSymbolTokenEquals('.')) {
                arrayList2.add(this.parseBodyFormula());
                while (!this.m_tokenizer.nonSymbolTokenEquals('.')) {
                    if (!this.m_tokenizer.nonSymbolTokenEquals(',') && !this.m_tokenizer.nonSymbolTokenEquals('&')) {
                        throw new ParsingException("Literals in a rule body should be separated by ',' or by '&'.");
                    }
                    this.nextToken();
                    arrayList2.add(this.parseBodyFormula());
                }
            }
            this.nextToken();
            Rule rule = Rule.create(arrayList, arrayList2);
            this.m_inputConsumer.consumeRule(n, n2, rule);
        }
    }

    protected void parseBase() throws ParsingException, IOException {
        if (!this.m_tokenizer.isQuotedIRI()) {
            throw new ParsingException("Base IRI of the form <IRI> expected.");
        }
        this.m_baseIRI = URI.create(this.m_tokenizer.getToken());
        this.nextToken();
    }

    public void bind(InputSource inputSource) throws ParsingException, IOException {
        this.m_tokenizer = new CommonTokenizer(inputSource);
        this.nextToken();
    }

    public void bind(InputStream inputStream) throws ParsingException, IOException {
        this.m_tokenizer = new CommonTokenizer(inputStream);
        this.nextToken();
    }

    public void bind(Reader reader) throws ParsingException, IOException {
        this.m_tokenizer = new CommonTokenizer(reader);
        this.nextToken();
    }

    public void parse(InputConsumer inputConsumer) throws ParsingException, IOException {
        this.m_inputConsumer = inputConsumer;
        try {
            this.m_inputConsumer.start();
            while (this.m_tokenizer.isGood()) {
                if (this.m_tokenizer.lowerCaseTokenEquals(CommonTokenizer.TokenType.LANGUAGE_TAG, "@prefix")) {
                    this.parsePrefixMapping();
                    if (!this.m_tokenizer.nonSymbolTokenEquals('.')) {
                        throw new ParsingException("The prefix definition introduced by '@prefix' should be terminated by '.'.");
                    }
                    this.nextToken();
                    continue;
                }
                if (this.m_tokenizer.tokenEquals(CommonTokenizer.TokenType.LANGUAGE_TAG, "@base")) {
                    this.nextToken();
                    this.parseBase();
                    if (!this.m_tokenizer.nonSymbolTokenEquals('.')) {
                        throw new ParsingException("The base declaration introduced by '@base' should be terminated by '.'.");
                    }
                    this.nextToken();
                    continue;
                }
                if (this.m_tokenizer.symbolLowerCaseTokenEquals("prefix")) {
                    this.parsePrefixMapping();
                    continue;
                }
                if (this.m_tokenizer.symbolLowerCaseTokenEquals("base")) {
                    this.nextToken();
                    this.parseBase();
                    continue;
                }
                this.parseFactOrRule(this.m_tokenizer.getCurrentCodePointLine(), this.m_tokenizer.getCurrentCodePointColumn());
            }
            this.m_inputConsumer.finish();
        }
        finally {
            this.m_inputConsumer = null;
        }
    }

    public boolean isEOF() {
        return this.m_tokenizer.isEOF();
    }

    public TupleTableAtom parseTupleTableAtom() throws ParsingException, IOException {
        TupleTableName tupleTableName;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (this.m_tokenizer.getTokenType() == CommonTokenizer.TokenType.SYMBOL || this.m_tokenizer.getTokenType() == CommonTokenizer.TokenType.QUOTED_STRING) {
            tupleTableName = TupleTableName.create(this.m_tokenizer.getToken());
            this.nextToken();
            if (this.m_tokenizer.nonSymbolTokenEquals('(')) {
                this.nextToken();
                if (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals(')')) {
                    arrayList.add(this.parseTerm());
                    while (this.m_tokenizer.nonSymbolTokenEquals(',')) {
                        this.nextToken();
                        arrayList.add(this.parseTerm());
                    }
                    if (!this.m_tokenizer.nonSymbolTokenEquals(')')) {
                        throw new ParsingException("A tuple table atom must be terminated by ')'.");
                    }
                }
                this.nextToken();
            }
        } else {
            if (this.m_tokenizer.nonSymbolTokenEquals('[')) {
                this.nextToken();
                arrayList.add(this.parseTerm());
                if (!this.m_tokenizer.nonSymbolTokenEquals(',')) {
                    throw new ParsingException("Terms in an RDF atom should be separated by ','.");
                }
                this.nextToken();
                arrayList.add(this.parseTerm());
                if (!this.m_tokenizer.nonSymbolTokenEquals(',')) {
                    throw new ParsingException("Terms in an RDF atom should be separated by ','.");
                }
                this.nextToken();
                arrayList.add(this.parseTerm());
                if (!this.m_tokenizer.nonSymbolTokenEquals(']')) {
                    throw new ParsingException("An RDF atom should be terminated with ']'.");
                }
                this.nextToken();
            } else if (this.isIRI()) {
                Term term = this.parseTerm();
                if (!this.m_tokenizer.nonSymbolTokenEquals('[')) {
                    throw new ParsingException("Abbreviated RDF atoms must contain '[' after an IRI.");
                }
                this.nextToken();
                arrayList.add(this.parseTerm());
                if (this.m_tokenizer.nonSymbolTokenEquals(',')) {
                    this.nextToken();
                    arrayList.add(term);
                    arrayList.add(this.parseTerm());
                } else {
                    arrayList.add(IRI.RDF_TYPE);
                    arrayList.add(term);
                }
                if (!this.m_tokenizer.nonSymbolTokenEquals(']')) {
                    throw new ParsingException("Abbreviated RDF atoms must be finished with ']'.");
                }
                this.nextToken();
            } else {
                throw new ParsingException("Malformed atom.");
            }
            if (this.m_tokenizer.isVariable() || this.isResource()) {
                arrayList.add(0, this.parseTerm());
                tupleTableName = TupleTableName.QUADS;
            } else if (!this.m_defaultGraph.equals(Literal.UNDEF)) {
                arrayList.add(0, this.m_defaultGraph);
                tupleTableName = TupleTableName.QUADS;
            } else {
                tupleTableName = TupleTableName.DEFAULT_TRIPLES;
            }
        }
        return TupleTableAtom.create(tupleTableName, arrayList);
    }

    public Rule parseRule() throws ParsingException, IOException {
        ArrayList<TupleTableAtom> arrayList = new ArrayList<TupleTableAtom>();
        arrayList.add(this.parseTupleTableAtom());
        while (this.m_tokenizer.isGood() && !this.m_tokenizer.nonSymbolTokenEquals(":-")) {
            if (!this.m_tokenizer.nonSymbolTokenEquals(',') && !this.m_tokenizer.nonSymbolTokenEquals('&')) {
                throw new ParsingException("Atoms in a rule head should be separated by ',' or by '&'.");
            }
            this.nextToken();
            arrayList.add(this.parseTupleTableAtom());
        }
        if (!this.m_tokenizer.nonSymbolTokenEquals(":-")) {
            throw new ParsingException("Expected ':-' in the rule.");
        }
        this.nextToken();
        ArrayList<BodyFormula> arrayList2 = new ArrayList<BodyFormula>();
        if (!this.m_tokenizer.nonSymbolTokenEquals('.')) {
            arrayList2.add(this.parseBodyFormula());
            while (!this.m_tokenizer.nonSymbolTokenEquals('.')) {
                if (!this.m_tokenizer.nonSymbolTokenEquals(',') && !this.m_tokenizer.nonSymbolTokenEquals('&')) {
                    throw new ParsingException("Literals in a rule body should be separated by ',' or by '&'.");
                }
                this.nextToken();
                arrayList2.add(this.parseBodyFormula());
            }
        }
        this.nextToken();
        return Rule.create(arrayList, arrayList2);
    }
}

