/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.sparql.statement;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.expression.Expression;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;
import tech.oxfordsemantic.jrdfox.logic.expression.Variable;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.GroupGraphPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.ValuesPattern;
import tech.oxfordsemantic.jrdfox.util.ImmutablePair;
import tech.oxfordsemantic.jrdfox.util.ImmutableQueryBody;
import tech.oxfordsemantic.jrdfox.util.MutableQueryBody;

public interface QueryBody
extends Serializable {
    public static final long QUERY_NO_OFFSET = 0L;
    public static final long QUERY_NO_LIMIT = Long.MAX_VALUE;

    public List<Resource> getDatasetDefaultGraphs();

    public List<Resource> getDatasetNamedGraphs();

    public GroupGraphPattern getWherePattern();

    public void setWherePattern(GroupGraphPattern var1);

    public List<GroupCondition> getGroupBy();

    public List<Expression> getHaving();

    public List<OrderCondition> getOrderBy();

    public long getOffset();

    public void setOffset(long var1);

    public long getLimit();

    public void setLimit(long var1);

    public ValuesPattern getValuesPattern();

    public void setValuesPattern(ValuesPattern var1);

    public void toString(Prefixes var1, Consumer<String> var2, boolean var3);

    public static QueryBody createImmutable(List<Resource> list, List<Resource> list2, GroupGraphPattern groupGraphPattern, List<GroupCondition> list3, List<Expression> list4, List<OrderCondition> list5, long l, long l2, ValuesPattern valuesPattern) {
        return new ImmutableQueryBody(list, list2, groupGraphPattern, list3, list4, list5, l, l2, valuesPattern);
    }

    public static QueryBody createImmutable(Resource[] resourceArray, Resource[] resourceArray2, GroupGraphPattern groupGraphPattern, GroupCondition[] groupConditionArray, Expression[] expressionArray, OrderCondition[] orderConditionArray, long l, long l2, ValuesPattern valuesPattern) {
        return new ImmutableQueryBody(Arrays.asList(resourceArray), Arrays.asList(resourceArray2), groupGraphPattern, Arrays.asList(groupConditionArray), Arrays.asList(expressionArray), Arrays.asList(orderConditionArray), l, l2, valuesPattern);
    }

    public static QueryBody createImmutable(QueryBody queryBody) {
        if (queryBody instanceof ImmutableQueryBody) {
            return queryBody;
        }
        return new ImmutableQueryBody(queryBody.getDatasetDefaultGraphs(), queryBody.getDatasetNamedGraphs(), queryBody.getWherePattern(), queryBody.getGroupBy(), queryBody.getHaving(), queryBody.getOrderBy(), queryBody.getOffset(), queryBody.getLimit(), queryBody.getValuesPattern());
    }

    public static QueryBody createMutable() {
        return new MutableQueryBody();
    }

    public static class OrderCondition
    extends ImmutablePair<SortOrder, Expression> {
        private static final long serialVersionUID = 916951245572439382L;
        public static final OrderCondition[] EMPTY_ARRAY = new OrderCondition[0];

        public OrderCondition(SortOrder sortOrder, Expression expression) {
            super(sortOrder, expression);
        }

        public SortOrder getSortOrder() {
            return (SortOrder)((Object)this.m_first);
        }

        public Expression getExpression() {
            return (Expression)this.m_second;
        }
    }

    public static class GroupCondition
    extends ImmutablePair<Expression, Variable> {
        private static final long serialVersionUID = 8636061274211404819L;
        public static final GroupCondition[] EMPTY_ARRAY = new GroupCondition[0];

        public GroupCondition(Expression expression, Variable variable) {
            super(expression, variable);
        }

        public Expression getExpression() {
            return (Expression)this.m_first;
        }

        public Variable getVariable() {
            return (Variable)this.m_second;
        }
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }
}

