/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.sparql.statement;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.LogicVisitor;
import tech.oxfordsemantic.jrdfox.logic.expression.Expression;
import tech.oxfordsemantic.jrdfox.logic.expression.Variable;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Query;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.QueryBody;
import tech.oxfordsemantic.jrdfox.util.ImmutableArrayList;
import tech.oxfordsemantic.jrdfox.util.ImmutablePair;
import tech.oxfordsemantic.jrdfox.util.ImmutableQueryBody;
import tech.oxfordsemantic.jrdfox.util.InterningManager;
import tech.oxfordsemantic.jrdfox.util.Primes;

public class SelectQuery
extends Query {
    protected final boolean m_distinct;
    protected final boolean m_allPossibleVariables;
    protected final ImmutableArrayList<SelectionPair> m_selection;
    private static final long serialVersionUID = 771620049078077763L;
    protected static final int s_classHashCodeTimes31 = 31 * SelectQuery.class.hashCode();
    protected static InterningManager.Creator s_creator = new InterningManager.Creator(){

        @Override
        public InterningManager.InternedObject create(Object object, Object object2, Object object3, Object object4) {
            return new SelectQuery((Boolean)object, (Boolean)object2, (List)object3, (QueryBody)object4);
        }
    };

    protected SelectQuery(boolean bl, boolean bl2, List<SelectionPair> list, QueryBody queryBody) {
        super((ImmutableQueryBody)QueryBody.createImmutable(queryBody));
        this.m_distinct = bl;
        this.m_allPossibleVariables = bl2;
        this.m_selection = ImmutableArrayList.create(list, SelectionPair.EMPTY_ARRAY);
    }

    public boolean getDistinct() {
        return this.m_distinct;
    }

    public boolean getAllPossibleVariables() {
        return this.m_allPossibleVariables;
    }

    public List<SelectionPair> getSelection() {
        return this.m_selection;
    }

    public QueryBody getQueryBody() {
        return this.m_queryBody;
    }

    @Override
    public <E> E accept(LogicVisitor<E> logicVisitor) {
        return logicVisitor.visit(this);
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        if (this.m_distinct && !this.m_allPossibleVariables && this.m_selection.isEmpty()) {
            consumer.accept("ASK ");
        } else {
            consumer.accept("SELECT");
            if (this.m_distinct) {
                consumer.accept(" DISTINCT");
            }
            if (this.m_allPossibleVariables) {
                consumer.accept(" *");
            }
            for (int i = 0; i < ((SelectionPair[])this.m_selection.m_elements).length; ++i) {
                SelectionPair selectionPair = this.m_selection.get(i);
                consumer.accept(" ");
                if (((Expression)selectionPair.m_first).equals(selectionPair.m_second)) {
                    ((Variable)selectionPair.m_second).toString(prefixes, consumer);
                    continue;
                }
                consumer.accept("(");
                ((Expression)selectionPair.m_first).toString(prefixes, consumer);
                consumer.accept(" AS ");
                ((Variable)selectionPair.m_second).toString(prefixes, consumer);
                consumer.accept(")");
            }
            consumer.accept(" ");
        }
        this.m_queryBody.toString(prefixes, consumer, true);
    }

    public static SelectQuery create(boolean bl, boolean bl2, List<SelectionPair> list, QueryBody queryBody) {
        return InterningManager.s_instance.intern(SelectQuery.hashCode(s_classHashCodeTimes31, Primes.SMALL_PRIMES[bl ? 1 : 2], Primes.SMALL_PRIMES[bl2 ? 1 : 2], list.hashCode(), queryBody.hashCode()), SelectQuery.class, s_creator, bl, bl2, list, queryBody);
    }

    public static SelectQuery create(boolean bl, boolean bl2, SelectionPair[] selectionPairArray, QueryBody queryBody) {
        return SelectQuery.create(bl, bl2, Arrays.asList(selectionPairArray), queryBody);
    }

    @Override
    protected boolean interningEquals(Class<?> clazz, Object object, Object object2, Object object3, Object object4) {
        return clazz == SelectQuery.class && this.m_distinct == (Boolean)object && this.m_allPossibleVariables == (Boolean)object2 && this.m_selection.equals(object3) && this.m_queryBody.equals(object4);
    }

    protected Object readResolve() {
        return SelectQuery.create(this.m_distinct, this.m_allPossibleVariables, this.m_selection, (QueryBody)this.m_queryBody);
    }

    public static class SelectionPair
    extends ImmutablePair<Expression, Variable> {
        private static final long serialVersionUID = 4179191319484526928L;
        public static final SelectionPair[] EMPTY_ARRAY = new SelectionPair[0];

        public SelectionPair(Expression expression, Variable variable) {
            super(expression, variable);
        }

        public Expression getExpression() {
            return (Expression)this.m_first;
        }

        public Variable getVariable() {
            return (Variable)this.m_second;
        }
    }
}

