/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.util;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.LogicObject;
import tech.oxfordsemantic.jrdfox.logic.expression.ExistenceExpression;
import tech.oxfordsemantic.jrdfox.logic.expression.Expression;
import tech.oxfordsemantic.jrdfox.logic.expression.FunctionCall;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;
import tech.oxfordsemantic.jrdfox.logic.expression.Variable;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.GroupGraphPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.ValuesPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.QueryBody;
import tech.oxfordsemantic.jrdfox.util.ImmutableArrayList;
import tech.oxfordsemantic.jrdfox.util.InterningManager;

public class ImmutableQueryBody
implements QueryBody {
    protected final ImmutableArrayList<Resource> m_datasetDefaultGraphs;
    protected final ImmutableArrayList<Resource> m_datasetNamedGraphs;
    protected final GroupGraphPattern m_wherePattern;
    protected final ImmutableArrayList<QueryBody.GroupCondition> m_groupBy;
    protected final ImmutableArrayList<Expression> m_having;
    protected final ImmutableArrayList<QueryBody.OrderCondition> m_orderBy;
    protected final long m_offset;
    protected final long m_limit;
    protected final ValuesPattern m_valuesPattern;
    private static final long serialVersionUID = 3217675425352399384L;

    public ImmutableQueryBody(List<Resource> list, List<Resource> list2, GroupGraphPattern groupGraphPattern, List<QueryBody.GroupCondition> list3, List<Expression> list4, List<QueryBody.OrderCondition> list5, long l, long l2, ValuesPattern valuesPattern) {
        this.m_datasetDefaultGraphs = ImmutableArrayList.create(list, Resource.EMPTY_ARRAY);
        this.m_datasetNamedGraphs = ImmutableArrayList.create(list2, Resource.EMPTY_ARRAY);
        this.m_wherePattern = groupGraphPattern;
        this.m_groupBy = ImmutableArrayList.create(list3, QueryBody.GroupCondition.EMPTY_ARRAY);
        this.m_having = ImmutableArrayList.create(list4, Expression.EMPTY_ARRAY);
        this.m_orderBy = ImmutableArrayList.create(list5, QueryBody.OrderCondition.EMPTY_ARRAY);
        this.m_offset = l;
        this.m_limit = l2;
        this.m_valuesPattern = valuesPattern;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof QueryBody)) {
            return false;
        }
        QueryBody queryBody = (QueryBody)object;
        return this.m_offset == queryBody.getOffset() && this.m_limit == queryBody.getLimit() && InterningManager.InternedObject.flatEquals(this.m_datasetDefaultGraphs, queryBody.getDatasetDefaultGraphs()) && InterningManager.InternedObject.flatEquals(this.m_datasetNamedGraphs, queryBody.getDatasetNamedGraphs()) && this.m_wherePattern.equals(queryBody.getWherePattern()) && this.m_groupBy.equals(queryBody.getGroupBy()) && InterningManager.InternedObject.flatEquals(this.m_having, queryBody.getHaving()) && this.m_orderBy.equals(queryBody.getOrderBy()) && Objects.equals(this.m_valuesPattern, queryBody.getValuesPattern());
    }

    public int hashCode() {
        return ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(Long.hashCode(this.m_offset), Long.hashCode(this.m_limit)), this.m_datasetDefaultGraphs), this.m_datasetNamedGraphs), this.m_wherePattern.hashCode()), this.m_groupBy), this.m_having), this.m_orderBy), Objects.hashCode(this.m_valuesPattern));
    }

    @Override
    public List<Resource> getDatasetDefaultGraphs() {
        return this.m_datasetDefaultGraphs;
    }

    @Override
    public List<Resource> getDatasetNamedGraphs() {
        return this.m_datasetNamedGraphs;
    }

    @Override
    public GroupGraphPattern getWherePattern() {
        return this.m_wherePattern;
    }

    @Override
    public void setWherePattern(GroupGraphPattern groupGraphPattern) {
        throw new UnsupportedOperationException("This QueryBody object is immutable.");
    }

    @Override
    public List<QueryBody.GroupCondition> getGroupBy() {
        return this.m_groupBy;
    }

    @Override
    public List<Expression> getHaving() {
        return this.m_having;
    }

    @Override
    public List<QueryBody.OrderCondition> getOrderBy() {
        return this.m_orderBy;
    }

    @Override
    public long getOffset() {
        return this.m_offset;
    }

    @Override
    public void setOffset(long l) {
        throw new UnsupportedOperationException("This QueryBody object is immutable.");
    }

    @Override
    public long getLimit() {
        return this.m_limit;
    }

    @Override
    public void setLimit(long l) {
        throw new UnsupportedOperationException("This QueryBody object is immutable.");
    }

    @Override
    public ValuesPattern getValuesPattern() {
        return this.m_valuesPattern;
    }

    @Override
    public void setValuesPattern(ValuesPattern valuesPattern) {
        throw new UnsupportedOperationException("This QueryBody object is immutable.");
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer, boolean bl) {
        Serializable serializable;
        int n;
        for (n = 0; n < ((Resource[])this.m_datasetDefaultGraphs.m_elements).length; ++n) {
            consumer.accept(bl ? "FROM " : "USING ");
            ((Resource[])this.m_datasetDefaultGraphs.m_elements)[n].toString(prefixes, consumer);
        }
        for (n = 0; n < ((Resource[])this.m_datasetNamedGraphs.m_elements).length; ++n) {
            consumer.accept(bl ? "FROM NAMED " : "USING NAMED ");
            ((Resource[])this.m_datasetNamedGraphs.m_elements)[n].toString(prefixes, consumer);
        }
        consumer.accept("WHERE ");
        this.m_wherePattern.toString(prefixes, consumer);
        if (!this.m_groupBy.isEmpty()) {
            consumer.accept(" GROUP BY");
            for (n = 0; n < ((QueryBody.GroupCondition[])this.m_groupBy.m_elements).length; ++n) {
                serializable = ((QueryBody.GroupCondition[])this.m_groupBy.m_elements)[n];
                consumer.accept(" ");
                if (((QueryBody.GroupCondition)serializable).m_second == null) {
                    Expression expression = (Expression)((QueryBody.GroupCondition)serializable).m_first;
                    if (expression instanceof ExistenceExpression || expression instanceof FunctionCall && ((FunctionCall)expression).isPrintedAsFunction()) {
                        expression.toString(prefixes, consumer);
                        continue;
                    }
                    consumer.accept("(");
                    expression.toString(prefixes, consumer);
                    consumer.accept(")");
                    continue;
                }
                if (((QueryBody.GroupCondition)serializable).m_second == ((QueryBody.GroupCondition)serializable).m_first) {
                    ((Variable)((QueryBody.GroupCondition)serializable).m_second).toString(prefixes, consumer);
                    continue;
                }
                consumer.accept("(");
                ((Expression)((QueryBody.GroupCondition)serializable).m_first).toString(prefixes, consumer);
                consumer.accept(" AS ");
                ((Variable)((QueryBody.GroupCondition)serializable).m_second).toString(prefixes, consumer);
                consumer.accept(")");
            }
        }
        if (!this.m_having.isEmpty()) {
            consumer.accept(" HAVING");
            for (n = 0; n < ((Expression[])this.m_having.m_elements).length; ++n) {
                serializable = ((Expression[])this.m_having.m_elements)[n];
                consumer.accept(" ");
                if (serializable instanceof ExistenceExpression || serializable instanceof FunctionCall && ((FunctionCall)serializable).isPrintedAsFunction()) {
                    ((LogicObject)serializable).toString(prefixes, consumer);
                    continue;
                }
                consumer.accept("(");
                ((LogicObject)serializable).toString(prefixes, consumer);
                consumer.accept(")");
            }
        }
        if (!this.m_orderBy.isEmpty()) {
            consumer.accept(" ORDER BY");
            for (n = 0; n < ((QueryBody.OrderCondition[])this.m_orderBy.m_elements).length; ++n) {
                serializable = ((QueryBody.OrderCondition[])this.m_orderBy.m_elements)[n];
                if (((QueryBody.OrderCondition)serializable).m_first == QueryBody.SortOrder.ASCENDING) {
                    consumer.accept(" ");
                    if (((QueryBody.OrderCondition)serializable).m_second instanceof Variable || ((QueryBody.OrderCondition)serializable).m_second instanceof ExistenceExpression || ((QueryBody.OrderCondition)serializable).m_second instanceof FunctionCall && ((FunctionCall)((QueryBody.OrderCondition)serializable).m_second).isPrintedAsFunction()) {
                        ((Expression)((QueryBody.OrderCondition)serializable).m_second).toString(prefixes, consumer);
                        continue;
                    }
                    consumer.accept("(");
                    ((Expression)((QueryBody.OrderCondition)serializable).m_second).toString(prefixes, consumer);
                    consumer.accept(")");
                    continue;
                }
                consumer.accept(" DESC(");
                ((Expression)((QueryBody.OrderCondition)serializable).m_second).toString(prefixes, consumer);
                consumer.accept(")");
            }
        }
        if (this.m_offset != 0L) {
            consumer.accept(" OFFSET ");
            consumer.accept(String.valueOf(this.m_offset));
        }
        if (this.m_limit != Long.MAX_VALUE) {
            consumer.accept(" LIMIT ");
            consumer.accept(String.valueOf(this.m_limit));
        }
        if (this.m_valuesPattern != null) {
            consumer.accept(" ");
            this.m_valuesPattern.toString(prefixes, consumer);
        }
    }

    protected static int hashCode(int n, int n2) {
        return 31 * n + n2;
    }

    public static <E> int hashCode(int n, List<E> list) {
        if (list instanceof RandomAccess) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                n = 31 * n + list.get(i).hashCode();
            }
        } else {
            for (E e : list) {
                n = 31 * n + e.hashCode();
            }
        }
        return n;
    }
}

