/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.formats.internal.TurtleSyntax;

public class Prefixes
implements Serializable {
    private static final long serialVersionUID = -158185482289831766L;
    protected static final int[] HEXtoDEC;
    protected static final String[] HEX2;
    public static final Prefixes s_defaultPrefixes;
    public static final Prefixes s_emptyPrefixes;
    protected final Map<String, PrefixData> m_prefixIRIsByPrefixName;
    protected final Map<String, PrefixData> m_prefixIRIsByPrefixNameUnmodifiable;

    public Prefixes() {
        this.m_prefixIRIsByPrefixName = new TreeMap<String, PrefixData>();
        this.m_prefixIRIsByPrefixNameUnmodifiable = Collections.unmodifiableMap(this.m_prefixIRIsByPrefixName);
    }

    public Prefixes(Prefixes prefixes) {
        this.m_prefixIRIsByPrefixName = new TreeMap<String, PrefixData>(prefixes.m_prefixIRIsByPrefixName);
        this.m_prefixIRIsByPrefixNameUnmodifiable = Collections.unmodifiableMap(this.m_prefixIRIsByPrefixName);
    }

    protected static int getHexCodePoint(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            char c = charSequence.charAt(n);
            int n4 = HEXtoDEC[c];
            if (n4 == -1) {
                return -1;
            }
            n3 = n3 * 16 + n4;
            ++n;
        }
        return n3;
    }

    public DecodeResult decodeIRI(CharSequence charSequence, StringBuilder stringBuilder) {
        int n = charSequence.length();
        if (n >= 2 && charSequence.charAt(0) == '<' && charSequence.charAt(n - 1) == '>') {
            Prefixes.appendUnescapedIRI(charSequence, 1, n - 2, stringBuilder);
            return DecodeResult.SUCCESSFUL;
        }
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) != ':') continue;
            int n2 = i + 1;
            String string = charSequence.subSequence(0, n2).toString();
            PrefixData prefixData = this.m_prefixIRIsByPrefixName.get(string);
            if (prefixData == null) {
                stringBuilder.append(charSequence);
                return DecodeResult.PREFIX_NAME_NOT_BOUND;
            }
            stringBuilder.ensureCapacity(stringBuilder.length() + prefixData.getIRI().length() + (n - n2));
            stringBuilder.append(prefixData.getIRI());
            for (int j = n2; j < n; ++j) {
                char c = charSequence.charAt(j);
                if (c == '\\') {
                    if (++j >= n) continue;
                    stringBuilder.append(charSequence.charAt(j));
                    continue;
                }
                stringBuilder.append(charSequence.charAt(j));
            }
            return DecodeResult.SUCCESSFUL;
        }
        stringBuilder.append(charSequence);
        return DecodeResult.NO_PREFIX_NAME;
    }

    public DecodeResult decodeIRI(CharSequence charSequence, Consumer<String> consumer) {
        StringBuilder stringBuilder = new StringBuilder();
        DecodeResult decodeResult = this.decodeIRI(charSequence, stringBuilder);
        consumer.accept(stringBuilder.toString());
        return decodeResult;
    }

    public String decodeIRI(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        this.decodeIRI(charSequence, stringBuilder);
        return stringBuilder.toString();
    }

    protected static boolean startsWith(CharSequence charSequence, String string) {
        if (charSequence instanceof String) {
            return ((String)charSequence).startsWith(string);
        }
        int n = string.length();
        if (charSequence.length() < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected static CanEncodeResult canEncodeIRI(CharSequence charSequence, String string) {
        char c;
        int n;
        int n2;
        int n3;
        if (!Prefixes.startsWith(charSequence, string)) {
            return CanEncodeResult.NO;
        }
        CanEncodeResult canEncodeResult = CanEncodeResult.YES_NO_ESCAPING_NEEDED;
        int n4 = string.length();
        if (n4 < (n3 = charSequence.length())) {
            n2 = charSequence.charAt(n4);
            if (TurtleSyntax.is_PN_LOCAL_ESC(n2)) {
                if (n2 != 95 && (n2 != 37 || n4 + 2 >= n3 || HEXtoDEC[charSequence.charAt(n4) + '\u0001'] == -1 || HEXtoDEC[charSequence.charAt(n4) + 2] == -1)) {
                    canEncodeResult = CanEncodeResult.YES_ESCAPING_NEEDED;
                }
                ++n4;
            } else {
                n = charSequence.charAt(n4);
                if (55296 <= n && n <= 56319 && ++n4 < n3 && '\udc00' <= (c = charSequence.charAt(n4)) && c <= '\udfff') {
                    n = (n - 55296 << 10 | c - 56320) + 65536;
                    ++n4;
                }
                if (!TurtleSyntax.is_PN_CHARS_U_NUM_COLON(n)) {
                    return CanEncodeResult.NO;
                }
            }
        }
        while (n4 < n3) {
            n2 = charSequence.charAt(n4);
            if (TurtleSyntax.is_PN_LOCAL_ESC(n2)) {
                if (!(n2 == 95 || n2 == 45 || n2 == 46 && n4 + 1 < n3 || n2 == 37 && n4 + 2 < n3 && HEXtoDEC[charSequence.charAt(n4) + '\u0001'] != -1 && HEXtoDEC[charSequence.charAt(n4) + 2] != -1)) {
                    canEncodeResult = CanEncodeResult.YES_ESCAPING_NEEDED;
                }
                ++n4;
                continue;
            }
            n = n2;
            if (55296 <= n && n <= 56319 && ++n4 < n3 && '\udc00' <= (c = charSequence.charAt(n4)) && c <= '\udfff') {
                n = (n - 55296 << 10 | c - 56320) + 65536;
                ++n4;
            }
            if (TurtleSyntax.is_PN_CHARS_COLON_DOT(n)) continue;
            return CanEncodeResult.NO;
        }
        return canEncodeResult;
    }

    public boolean encodeIRI(CharSequence charSequence, StringBuilder stringBuilder) {
        Map.Entry<String, PrefixData> entry = null;
        boolean bl = false;
        int c2 = 0;
        for (Map.Entry<String, PrefixData> entry2 : this.m_prefixIRIsByPrefixName.entrySet()) {
            String string = entry2.getValue().getIRI();
            CanEncodeResult canEncodeResult = Prefixes.canEncodeIRI(charSequence, string);
            if (canEncodeResult == CanEncodeResult.NO) continue;
            int c = string.length();
            if (entry != null && c <= c2 && (c < c2 || entry2.getKey().compareTo(entry.getKey()) >= 0)) continue;
            entry = entry2;
            c2 = c;
            bl = canEncodeResult == CanEncodeResult.YES_ESCAPING_NEEDED;
        }
        if (entry != null) {
            String string = ((PrefixData)entry.getValue()).getIRI();
            if (bl) {
                stringBuilder.append((String)entry.getKey());
                int n = string.length();
                int n2 = charSequence.length();
                int n3 = n2 - 2;
                if (n != n2 && (charSequence.charAt(n) == '-' || charSequence.charAt(n) == '.')) {
                    stringBuilder.append('\\');
                    stringBuilder.append(charSequence.charAt(n));
                    ++n;
                }
                while (n < n2) {
                    char c = charSequence.charAt(n);
                    if (c == '%' && n < n3 && HEXtoDEC[charSequence.charAt(n + 1)] != -1 && HEXtoDEC[charSequence.charAt(n + 2)] != -1) {
                        int n4 = n;
                        stringBuilder.append(charSequence, n4, n += 3);
                        continue;
                    }
                    if (TurtleSyntax.is_PN_LOCAL_ESC_WITHOUT_UNDERSCORE_MINUS_DOT(c) || c == '.' && n + 1 == n2) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                    ++n;
                }
            } else {
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append(charSequence, string.length(), charSequence.length());
            }
            return true;
        }
        stringBuilder.append('<');
        Prefixes.appendEscapedIRI(charSequence, 0, charSequence.length(), stringBuilder);
        stringBuilder.append('>');
        return false;
    }

    public boolean encodeIRI(CharSequence charSequence, Consumer<String> consumer) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.encodeIRI(charSequence, stringBuilder);
        consumer.accept(stringBuilder.toString());
        return bl;
    }

    public String encodeIRI(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        this.encodeIRI(charSequence, stringBuilder);
        return stringBuilder.toString();
    }

    public boolean prefixExists(String string) {
        return this.m_prefixIRIsByPrefixName.containsKey(string);
    }

    protected DeclareResult declarePrefixNoValidityCheck(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        Prefixes.appendEscapedIRI(string2, 0, string2.length(), stringBuilder);
        stringBuilder.append('>');
        PrefixData prefixData = this.m_prefixIRIsByPrefixName.put(string, new PrefixData(string2, stringBuilder.toString()));
        if (prefixData == null) {
            return DeclareResult.DECLARED_NEW;
        }
        if (prefixData.m_iri.equals(string2)) {
            return DeclareResult.NO_CHANGE;
        }
        return DeclareResult.REPLACED_EXISTING;
    }

    public DeclareResult declarePrefix(String string, String string2) {
        if (Prefixes.isValidPrefixName(string)) {
            return this.declarePrefixNoValidityCheck(string, string2);
        }
        return DeclareResult.INVALID_PREFIX_NAME;
    }

    public void declareStandardPrefixes() {
        this.declarePrefixNoValidityCheck("owl:", "http://www.w3.org/2002/07/owl#");
        this.declarePrefixNoValidityCheck("rdf:", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.declarePrefixNoValidityCheck("rdfox:", "https://rdfox.com/vocabulary#");
        this.declarePrefixNoValidityCheck("rdfs:", "http://www.w3.org/2000/01/rdf-schema#");
        this.declarePrefixNoValidityCheck("sh:", "http://www.w3.org/ns/shacl#");
        this.declarePrefixNoValidityCheck("swrl:", "http://www.w3.org/2003/11/swrl#");
        this.declarePrefixNoValidityCheck("swrlb:", "http://www.w3.org/2003/11/swrlb#");
        this.declarePrefixNoValidityCheck("xsd:", "http://www.w3.org/2001/XMLSchema#");
    }

    public boolean undeclarePrefix(String string) {
        return this.m_prefixIRIsByPrefixName.remove(string) != null;
    }

    public void clear() {
        this.m_prefixIRIsByPrefixName.clear();
    }

    public Map<String, PrefixData> getPrefixIRIsByPrefixName() {
        return this.m_prefixIRIsByPrefixNameUnmodifiable;
    }

    public static boolean isValidPrefixName(CharSequence charSequence) {
        char c;
        int n = 0;
        int n2 = charSequence.length() - 1;
        if (n > n2 || charSequence.charAt(n2) != ':') {
            return false;
        }
        if (n == n2) {
            return true;
        }
        if (charSequence.charAt(n2 - 1) == '.') {
            return false;
        }
        int n3 = charSequence.charAt(n);
        if (55296 <= n3 && n3 <= 56319 && ++n < n2 && '\udc00' <= (c = charSequence.charAt(n)) && c <= '\udfff') {
            n3 = (n3 - 55296 << 10 | c - 56320) + 65536;
            ++n;
        }
        if (!TurtleSyntax.is_PN_CHARS_BASE(n3)) {
            return false;
        }
        while (n < n2) {
            n3 = charSequence.charAt(n);
            if (55296 <= n3 && n3 <= 56319 && ++n < n2 && '\udc00' <= (c = charSequence.charAt(n)) && c <= '\udfff') {
                n3 = (n3 - 55296 << 10 | c - 56320) + 65536;
                ++n;
            }
            if (TurtleSyntax.is_PN_CHARS_DOT(n3)) continue;
            return false;
        }
        return true;
    }

    public static void appendUnescapedIRI(CharSequence charSequence, int n, int n2, StringBuilder stringBuilder) {
        stringBuilder.ensureCapacity(n2);
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            char c = charSequence.charAt(n3);
            if (c == '\\') {
                int n5;
                if (n3 + 6 < n4 && charSequence.charAt(n3 + 1) == 'u') {
                    n5 = Prefixes.getHexCodePoint(charSequence, n3 + 2, n3 + 6);
                    if (n5 != -1) {
                        stringBuilder.appendCodePoint(n5);
                        n3 += 6;
                        continue;
                    }
                } else if (n3 + 10 < n4 && charSequence.charAt(n3 + 1) == 'U' && (n5 = Prefixes.getHexCodePoint(charSequence, n3 + 2, n3 + 10)) != -1) {
                    stringBuilder.appendCodePoint(n5);
                    n3 += 10;
                    continue;
                }
            }
            stringBuilder.append(c);
            ++n3;
        }
    }

    public static void appendEscapedIRI(CharSequence charSequence, int n, int n2, StringBuilder stringBuilder) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = charSequence.charAt(i);
            if (c > '\u00ff' || TurtleSyntax.is_IRIREF(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("\\u00");
            stringBuilder.append(HEX2[c]);
        }
    }

    static {
        HEX2 = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
        s_emptyPrefixes = new ImmutablePrefixes();
        HEXtoDEC = new int[65526];
        for (int i = 0; i < HEXtoDEC.length; ++i) {
            Prefixes.HEXtoDEC[i] = 48 <= i && i <= 57 ? i - 48 : (65 <= i && i <= 70 ? i - 65 + 10 : (97 <= i && i <= 102 ? i - 97 + 10 : -1));
        }
        Prefixes prefixes = new Prefixes();
        prefixes.declareStandardPrefixes();
        s_defaultPrefixes = new ImmutablePrefixes(prefixes);
    }

    protected static class ImmutablePrefixes
    extends Prefixes {
        private static final long serialVersionUID = -6967971001547045732L;

        public ImmutablePrefixes() {
        }

        public ImmutablePrefixes(Prefixes prefixes) {
            super(prefixes);
        }

        @Override
        protected DeclareResult declarePrefixNoValidityCheck(String string, String string2) {
            throw new UnsupportedOperationException("This Prefixes object is immutable.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("This Prefixes object is immutable.");
        }
    }

    protected static enum CanEncodeResult {
        NO,
        YES_NO_ESCAPING_NEEDED,
        YES_ESCAPING_NEEDED;

    }

    public static enum DecodeResult {
        SUCCESSFUL,
        NO_PREFIX_NAME,
        PREFIX_NAME_NOT_BOUND;

    }

    public static enum DeclareResult {
        INVALID_PREFIX_NAME,
        NO_CHANGE,
        REPLACED_EXISTING,
        DECLARED_NEW;

    }

    public static class PrefixData {
        protected final String m_iri;
        protected final String m_encodedIRI;

        public PrefixData(String string, String string2) {
            this.m_iri = string;
            this.m_encodedIRI = string2;
        }

        public String getIRI() {
            return this.m_iri;
        }

        public String getEncodedIRI() {
            return this.m_encodedIRI;
        }
    }
}

