/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.sparql.statement;

import java.util.Objects;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.client.UpdateType;
import tech.oxfordsemantic.jrdfox.logic.LogicVisitor;
import tech.oxfordsemantic.jrdfox.logic.datalog.TupleTableName;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Update;
import tech.oxfordsemantic.jrdfox.util.InterningManager;
import tech.oxfordsemantic.jrdfox.util.Primes;

public class LoadUpdate
extends Update {
    protected final boolean m_silent;
    protected final UpdateType m_updateType;
    protected final String m_sourceIRI;
    protected final TupleTableName m_targetGraph;
    private static final long serialVersionUID = 7898076104363477848L;
    protected static final int s_classHashCodeTimes31 = 31 * LoadUpdate.class.hashCode();
    protected static InterningManager.Creator s_creator = new InterningManager.Creator(){

        @Override
        public InterningManager.InternedObject create(Object object, Object object2, Object object3, Object object4) {
            return new LoadUpdate((Boolean)object, (UpdateType)((Object)object2), (String)object3, (TupleTableName)object4);
        }
    };

    protected LoadUpdate(boolean bl, UpdateType updateType, String string, TupleTableName tupleTableName) {
        this.m_silent = bl;
        this.m_updateType = updateType;
        this.m_sourceIRI = string;
        this.m_targetGraph = tupleTableName;
    }

    public boolean getSilent() {
        return this.m_silent;
    }

    public UpdateType getUpdateType() {
        return this.m_updateType;
    }

    public String getSourceIRI() {
        return this.m_sourceIRI;
    }

    public TupleTableName getTargetGraph() {
        return this.m_targetGraph;
    }

    @Override
    public <E> E accept(LogicVisitor<E> logicVisitor) {
        return logicVisitor.visit(this);
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        consumer.accept(this.m_updateType == UpdateType.ADDITION ? "LOAD " : "UNLOAD ");
        if (this.m_silent) {
            consumer.accept("SILENT ");
        }
        consumer.accept(prefixes.encodeIRI(this.m_sourceIRI));
        if (this.m_targetGraph != null) {
            consumer.accept(" INTO GRAPH ");
            this.m_targetGraph.toString(prefixes, consumer);
        }
    }

    public static LoadUpdate create(boolean bl, UpdateType updateType, String string, TupleTableName tupleTableName) {
        return InterningManager.s_instance.intern(LoadUpdate.hashCode(s_classHashCodeTimes31, Primes.SMALL_PRIMES[bl ? 1 : 2], Integer.hashCode(updateType.getValue()), string.hashCode(), Objects.hashCode(tupleTableName)), LoadUpdate.class, s_creator, bl, updateType, string, tupleTableName);
    }

    @Override
    protected boolean interningEquals(Class<?> clazz, Object object, Object object2, Object object3, Object object4) {
        return clazz == LoadUpdate.class && this.m_silent == (Boolean)object && this.m_updateType.equals(object2) && this.m_sourceIRI.equals(object3) && Objects.equals(this.m_targetGraph, object4);
    }

    protected Object readResolve() {
        return LoadUpdate.create(this.m_silent, this.m_updateType, this.m_sourceIRI, this.m_targetGraph);
    }
}

