/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.expression.ExistenceExpression;
import tech.oxfordsemantic.jrdfox.logic.expression.Expression;
import tech.oxfordsemantic.jrdfox.logic.expression.FunctionCall;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;
import tech.oxfordsemantic.jrdfox.logic.expression.Variable;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.GroupGraphPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.pattern.ValuesPattern;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.QueryBody;
import tech.oxfordsemantic.jrdfox.util.ImmutableQueryBody;

public class MutableQueryBody
implements QueryBody {
    protected List<Resource> m_datasetDefaultGraphs = new ArrayList<Resource>();
    protected List<Resource> m_datasetNamedGraphs = new ArrayList<Resource>();
    protected GroupGraphPattern m_wherePattern = null;
    protected List<QueryBody.GroupCondition> m_groupBy = new ArrayList<QueryBody.GroupCondition>();
    protected List<Expression> m_having = new ArrayList<Expression>();
    protected List<QueryBody.OrderCondition> m_orderBy = new ArrayList<QueryBody.OrderCondition>();
    protected long m_offset = 0L;
    protected long m_limit = Long.MAX_VALUE;
    protected ValuesPattern m_valuesPattern = null;
    private static final long serialVersionUID = 6717309365824084320L;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof QueryBody)) {
            return false;
        }
        QueryBody queryBody = (QueryBody)object;
        return this.m_offset == queryBody.getOffset() && this.m_limit == queryBody.getLimit() && this.m_datasetDefaultGraphs.equals(queryBody.getDatasetDefaultGraphs()) && this.m_datasetNamedGraphs.equals(queryBody.getDatasetNamedGraphs()) && this.m_wherePattern.equals(queryBody.getWherePattern()) && this.m_groupBy.equals(queryBody.getGroupBy()) && this.m_having.equals(queryBody.getHaving()) && this.m_orderBy.equals(queryBody.getOrderBy()) && Objects.equals(this.m_valuesPattern, queryBody.getValuesPattern());
    }

    public int hashCode() {
        return ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(ImmutableQueryBody.hashCode(Long.hashCode(this.m_offset), Long.hashCode(this.m_limit)), this.m_datasetDefaultGraphs), this.m_datasetNamedGraphs), this.m_wherePattern.hashCode()), this.m_groupBy), this.m_having), this.m_orderBy), Objects.hashCode(this.m_valuesPattern));
    }

    @Override
    public List<Resource> getDatasetDefaultGraphs() {
        return this.m_datasetDefaultGraphs;
    }

    @Override
    public List<Resource> getDatasetNamedGraphs() {
        return this.m_datasetNamedGraphs;
    }

    @Override
    public GroupGraphPattern getWherePattern() {
        return this.m_wherePattern;
    }

    @Override
    public void setWherePattern(GroupGraphPattern groupGraphPattern) {
        this.m_wherePattern = groupGraphPattern;
    }

    @Override
    public List<QueryBody.GroupCondition> getGroupBy() {
        return this.m_groupBy;
    }

    @Override
    public List<Expression> getHaving() {
        return this.m_having;
    }

    @Override
    public List<QueryBody.OrderCondition> getOrderBy() {
        return this.m_orderBy;
    }

    @Override
    public long getOffset() {
        return this.m_offset;
    }

    @Override
    public void setOffset(long l) {
        this.m_offset = l;
    }

    @Override
    public long getLimit() {
        return this.m_limit;
    }

    @Override
    public void setLimit(long l) {
        this.m_limit = l;
    }

    @Override
    public ValuesPattern getValuesPattern() {
        return this.m_valuesPattern;
    }

    @Override
    public void setValuesPattern(ValuesPattern valuesPattern) {
        this.m_valuesPattern = valuesPattern;
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer, boolean bl) {
        for (Resource serializable : this.m_datasetDefaultGraphs) {
            consumer.accept(bl ? "FROM " : "USING ");
            serializable.toString(prefixes, consumer);
        }
        for (Resource resource : this.m_datasetNamedGraphs) {
            consumer.accept(bl ? "FROM NAMED " : "USING NAMED ");
            resource.toString(prefixes, consumer);
        }
        consumer.accept("WHERE ");
        this.m_wherePattern.toString(prefixes, consumer);
        if (!this.m_groupBy.isEmpty()) {
            consumer.accept(" GROUP BY");
            for (QueryBody.GroupCondition groupCondition : this.m_groupBy) {
                consumer.accept(" ");
                if (groupCondition.m_second == null) {
                    Expression expression = (Expression)groupCondition.m_first;
                    if (expression instanceof ExistenceExpression || expression instanceof FunctionCall && ((FunctionCall)expression).isPrintedAsFunction()) {
                        expression.toString(prefixes, consumer);
                        continue;
                    }
                    consumer.accept("(");
                    expression.toString(prefixes, consumer);
                    consumer.accept(")");
                    continue;
                }
                if (groupCondition.m_second == groupCondition.m_first) {
                    ((Variable)groupCondition.m_second).toString(prefixes, consumer);
                    continue;
                }
                consumer.accept("(");
                ((Expression)groupCondition.m_first).toString(prefixes, consumer);
                consumer.accept(" AS ");
                ((Variable)groupCondition.m_second).toString(prefixes, consumer);
                consumer.accept(")");
            }
        }
        if (!this.m_having.isEmpty()) {
            consumer.accept(" HAVING");
            for (Expression expression : this.m_having) {
                consumer.accept(" ");
                if (expression instanceof ExistenceExpression || expression instanceof FunctionCall && ((FunctionCall)expression).isPrintedAsFunction()) {
                    expression.toString(prefixes, consumer);
                    continue;
                }
                consumer.accept("(");
                expression.toString(prefixes, consumer);
                consumer.accept(")");
            }
        }
        if (!this.m_orderBy.isEmpty()) {
            consumer.accept(" ORDER BY");
            for (QueryBody.OrderCondition orderCondition : this.m_orderBy) {
                if (orderCondition.m_first == QueryBody.SortOrder.ASCENDING) {
                    consumer.accept(" ");
                    if (orderCondition.m_second instanceof ExistenceExpression || orderCondition.m_second instanceof FunctionCall && ((FunctionCall)orderCondition.m_second).isPrintedAsFunction()) {
                        ((Expression)orderCondition.m_second).toString(prefixes, consumer);
                        continue;
                    }
                    consumer.accept("(");
                    ((Expression)orderCondition.m_second).toString(prefixes, consumer);
                    consumer.accept(")");
                    continue;
                }
                consumer.accept(" DESC(");
                ((Expression)orderCondition.m_second).toString(prefixes, consumer);
                consumer.accept(")");
            }
        }
        if (this.m_offset != 0L) {
            consumer.accept(" OFFSET ");
            consumer.accept(String.valueOf(this.m_offset));
        }
        if (this.m_limit != Long.MAX_VALUE) {
            consumer.accept(" LIMIT ");
            consumer.accept(String.valueOf(this.m_limit));
        }
        if (this.m_valuesPattern != null) {
            consumer.accept(" ");
            this.m_valuesPattern.toString(prefixes, consumer);
        }
    }
}

