/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.LogicVisitor;
import tech.oxfordsemantic.jrdfox.logic.expression.Expression;
import tech.oxfordsemantic.jrdfox.util.ImmutableArrayList;
import tech.oxfordsemantic.jrdfox.util.ImmutablePair;
import tech.oxfordsemantic.jrdfox.util.InterningManager;
import tech.oxfordsemantic.jrdfox.util.Primes;

public class FunctionCall
extends Expression {
    protected final String m_functionName;
    protected final boolean m_isDistinct;
    protected final ImmutableArrayList<ScalarValue> m_scalarValues;
    protected final ImmutableArrayList<Expression> m_arguments;
    public static final String LOGICAL_OR = "internal:logical-or";
    public static final String LOGICAL_AND = "internal:logical-and";
    public static final String LOGICAL_NOT = "internal:logical-not";
    public static final String EQUAL = "internal:equal";
    public static final String NOT_EQUAL = "internal:not-equal";
    public static final String LESS_THAN = "internal:less-than";
    public static final String LESS_EQUAL_THAN = "internal:less-equal-than";
    public static final String GREATER_THAN = "internal:greater-than";
    public static final String GREATER_EQUAL_THAN = "internal:greater-equal-than";
    public static final String ADD = "internal:add";
    public static final String SUBTRACT = "internal:subtract";
    public static final String MULTIPLY = "internal:multiply";
    public static final String DIVIDE = "internal:divide";
    public static final String IDIV = "internal:idiv";
    public static final String MOD = "internal:mod";
    public static final String NUMERIC_UNARY_PLUS = "internal:numeric-unary-plus";
    public static final String NUMERIC_UNARY_MINUS = "internal:numeric-unary-minus";
    public static final String IN = "internal:in";
    public static final String NOT_IN = "internal:not-in";
    static final String[] DEC2toHEX2U = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
    protected static final Map<String, OperatorInfo> s_operatorInfos = new HashMap<String, OperatorInfo>();
    private static final long serialVersionUID = 2909098546182023276L;
    protected static final int s_classHashCodeTimes31;
    protected static InterningManager.Creator s_creator;

    protected FunctionCall(String string, boolean bl, List<ScalarValue> list, List<Expression> list2) {
        this.m_functionName = string;
        this.m_isDistinct = bl;
        this.m_scalarValues = ImmutableArrayList.create(list, ScalarValue.EMPTY_ARRAY);
        this.m_arguments = ImmutableArrayList.create(list2, Expression.EMPTY_ARRAY);
        OperatorInfo operatorInfo = s_operatorInfos.get(this.m_functionName);
        if (operatorInfo != null) {
            if (!operatorInfo.isArityCompatible(list2.size())) {
                throw new RuntimeException(String.format("Wrong number of parameters (%s) for function %s.", list2.size(), string));
            }
            if (!list.isEmpty()) {
                throw new RuntimeException(String.format("Function %s does not take scalar parameters.", string));
            }
        }
    }

    public String getFunctionName() {
        return this.m_functionName;
    }

    public boolean getIsDistinct() {
        return this.m_isDistinct;
    }

    public List<ScalarValue> getScalarValues() {
        return this.m_scalarValues;
    }

    public ImmutableArrayList<Expression> getArguments() {
        return this.m_arguments;
    }

    public boolean isPrintedAsFunction() {
        return s_operatorInfos.get(this.m_functionName) == null;
    }

    @Override
    public <E> E accept(LogicVisitor<E> logicVisitor) {
        return logicVisitor.visit(this);
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        String string;
        OperatorInfo operatorInfo = s_operatorInfos.get(this.m_functionName);
        String string2 = string = operatorInfo == null ? this.m_functionName : operatorInfo.m_text;
        if (operatorInfo == null) {
            int n;
            if (FunctionCall.shouldEncodeAsURI(string)) {
                prefixes.encodeIRI((CharSequence)string, consumer);
            } else {
                consumer.accept(string);
            }
            consumer.accept("(");
            if (this.m_isDistinct) {
                consumer.accept("DISTINCT ");
            }
            for (n = 0; n < ((Expression[])this.m_arguments.m_elements).length; ++n) {
                if (n != 0) {
                    consumer.accept(", ");
                }
                ((Expression[])this.m_arguments.m_elements)[n].toString(prefixes, consumer);
            }
            for (n = 0; n < ((ScalarValue[])this.m_scalarValues.m_elements).length; ++n) {
                ScalarValue scalarValue = ((ScalarValue[])this.m_scalarValues.m_elements)[n];
                consumer.accept("; ");
                consumer.accept((String)scalarValue.m_first);
                consumer.accept("=\"");
                String string3 = (String)scalarValue.m_second;
                int n2 = string3.length();
                block17: for (int i = 0; i < n2; ++i) {
                    char c = string3.charAt(i);
                    switch (c) {
                        case '\u0000': 
                        case '\u0001': 
                        case '\u0002': 
                        case '\u0003': 
                        case '\u0004': 
                        case '\u0005': 
                        case '\u0006': 
                        case '\u0007': 
                        case '\u000b': 
                        case '\u000e': 
                        case '\u000f': 
                        case '\u0010': 
                        case '\u0011': 
                        case '\u0012': 
                        case '\u0013': 
                        case '\u0014': 
                        case '\u0015': 
                        case '\u0016': 
                        case '\u0017': 
                        case '\u0018': 
                        case '\u0019': 
                        case '\u001a': 
                        case '\u001b': 
                        case '\u001c': 
                        case '\u001d': 
                        case '\u001e': 
                        case '\u001f': {
                            consumer.accept("\\u00");
                            consumer.accept(DEC2toHEX2U[c]);
                            continue block17;
                        }
                        case '\t': {
                            consumer.accept("\\t");
                            continue block17;
                        }
                        case '\b': {
                            consumer.accept("\\b");
                            continue block17;
                        }
                        case '\n': {
                            consumer.accept("\\n");
                            continue block17;
                        }
                        case '\r': {
                            consumer.accept("\\r");
                            continue block17;
                        }
                        case '\f': {
                            consumer.accept("\\f");
                            continue block17;
                        }
                        case '\"': {
                            consumer.accept("\\\"");
                            continue block17;
                        }
                        case '\\': {
                            consumer.accept("\\\\");
                            continue block17;
                        }
                        default: {
                            consumer.accept(String.valueOf(c));
                        }
                    }
                }
                consumer.accept("\"");
            }
            consumer.accept(")");
        } else {
            switch (operatorInfo.m_operatorType) {
                case UNARY: {
                    consumer.accept(string);
                    if (FunctionCall.getPrecedence(((Expression[])this.m_arguments.m_elements)[0]) <= operatorInfo.m_precedence) {
                        consumer.accept("(");
                        ((Expression[])this.m_arguments.m_elements)[0].toString(prefixes, consumer);
                        consumer.accept(")");
                        break;
                    }
                    ((Expression[])this.m_arguments.m_elements)[0].toString(prefixes, consumer);
                    break;
                }
                case BINARY_INFIX: 
                case NARY_INFIX: {
                    for (int i = 0; i < ((Expression[])this.m_arguments.m_elements).length; ++i) {
                        if (i != 0) {
                            consumer.accept(" ");
                            consumer.accept(string);
                            consumer.accept(" ");
                        }
                        if (FunctionCall.getPrecedence(((Expression[])this.m_arguments.m_elements)[i]) <= operatorInfo.m_precedence) {
                            consumer.accept("(");
                            ((Expression[])this.m_arguments.m_elements)[i].toString(prefixes, consumer);
                            consumer.accept(")");
                            continue;
                        }
                        ((Expression[])this.m_arguments.m_elements)[i].toString(prefixes, consumer);
                    }
                    break;
                }
                case IN_NOTIN: {
                    ((Expression[])this.m_arguments.m_elements)[0].toString(prefixes, consumer);
                    consumer.accept(" ");
                    consumer.accept(string);
                    consumer.accept(" (");
                    for (int i = 1; i < ((Expression[])this.m_arguments.m_elements).length; ++i) {
                        if (i != 1) {
                            consumer.accept(", ");
                        }
                        ((Expression[])this.m_arguments.m_elements)[i].toString(prefixes, consumer);
                    }
                    consumer.accept(")");
                }
            }
        }
    }

    public static FunctionCall create(String string, boolean bl, List<ScalarValue> list, List<Expression> list2) {
        return InterningManager.s_instance.intern(FunctionCall.hashCode(s_classHashCodeTimes31, string.hashCode(), Primes.SMALL_PRIMES[bl ? 1 : 2], FunctionCall.hashCode(list), FunctionCall.hashCode(list2)), FunctionCall.class, s_creator, string, bl, list, list2);
    }

    public static FunctionCall create(String string, boolean bl, ScalarValue[] scalarValueArray, Expression ... expressionArray) {
        return FunctionCall.create(string, bl, Arrays.asList(scalarValueArray), Arrays.asList(expressionArray));
    }

    public static FunctionCall create(String string, List<Expression> list) {
        return FunctionCall.create(string, false, Collections.emptyList(), list);
    }

    public static FunctionCall create(String string, Expression ... expressionArray) {
        return FunctionCall.create(string, false, Collections.emptyList(), Arrays.asList(expressionArray));
    }

    public static FunctionCall logicalOr(List<Expression> list) {
        return FunctionCall.create(LOGICAL_OR, false, Collections.emptyList(), list);
    }

    public static FunctionCall logicalOr(Expression ... expressionArray) {
        return FunctionCall.create(LOGICAL_OR, false, Collections.emptyList(), Arrays.asList(expressionArray));
    }

    public static FunctionCall logicalAnd(List<Expression> list) {
        return FunctionCall.create(LOGICAL_AND, false, Collections.emptyList(), list);
    }

    public static FunctionCall logicalAnd(Expression ... expressionArray) {
        return FunctionCall.create(LOGICAL_AND, false, Collections.emptyList(), Arrays.asList(expressionArray));
    }

    public static FunctionCall logicalNot(Expression expression) {
        return FunctionCall.create(LOGICAL_NOT, false, Collections.emptyList(), Collections.singletonList(expression));
    }

    public static FunctionCall equal(Expression expression, Expression expression2) {
        return FunctionCall.create(EQUAL, false, Collections.emptyList(), Arrays.asList(expression, expression2));
    }

    public static FunctionCall notEqual(Expression expression, Expression expression2) {
        return FunctionCall.create(NOT_EQUAL, false, Collections.emptyList(), Arrays.asList(expression, expression2));
    }

    public static FunctionCall lessThan(Expression expression, Expression expression2) {
        return FunctionCall.create(LESS_THAN, false, Collections.emptyList(), Arrays.asList(expression, expression2));
    }

    public static FunctionCall lessEqualThan(Expression expression, Expression expression2) {
        return FunctionCall.create(LESS_EQUAL_THAN, false, Collections.emptyList(), Arrays.asList(expression, expression2));
    }

    public static FunctionCall greaterThan(Expression expression, Expression expression2) {
        return FunctionCall.create(GREATER_THAN, false, Collections.emptyList(), Arrays.asList(expression, expression2));
    }

    public static FunctionCall greaterEqualThan(Expression expression, Expression expression2) {
        return FunctionCall.create(GREATER_EQUAL_THAN, false, Collections.emptyList(), Arrays.asList(expression, expression2));
    }

    public static FunctionCall add(List<Expression> list) {
        return FunctionCall.create(ADD, false, Collections.emptyList(), list);
    }

    public static FunctionCall add(Expression ... expressionArray) {
        return FunctionCall.create(ADD, false, Collections.emptyList(), Arrays.asList(expressionArray));
    }

    public static FunctionCall subtract(Expression expression, Expression expression2) {
        return FunctionCall.create(SUBTRACT, false, Collections.emptyList(), Arrays.asList(expression, expression2));
    }

    public static FunctionCall multiply(List<Expression> list) {
        return FunctionCall.create(MULTIPLY, false, Collections.emptyList(), list);
    }

    public static FunctionCall multiply(Expression ... expressionArray) {
        return FunctionCall.create(MULTIPLY, false, Collections.emptyList(), Arrays.asList(expressionArray));
    }

    public static FunctionCall divide(Expression expression, Expression expression2) {
        return FunctionCall.create(DIVIDE, false, Collections.emptyList(), Arrays.asList(expression, expression2));
    }

    public static FunctionCall numericUnaryPlus(Expression expression) {
        return FunctionCall.create(NUMERIC_UNARY_PLUS, false, Collections.emptyList(), Collections.singletonList(expression));
    }

    public static FunctionCall numericUnaryMinus(Expression expression) {
        return FunctionCall.create(NUMERIC_UNARY_MINUS, false, Collections.emptyList(), Collections.singletonList(expression));
    }

    protected static boolean shouldEncodeAsURI(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '#' && c != '/') continue;
            return true;
        }
        return false;
    }

    protected static int getPrecedence(Expression expression) {
        OperatorInfo operatorInfo;
        if (expression instanceof FunctionCall && (operatorInfo = s_operatorInfos.get(((FunctionCall)expression).m_functionName)) != null) {
            return operatorInfo.m_precedence;
        }
        return 1000;
    }

    @Override
    protected boolean interningEquals(Class<?> clazz, Object object, Object object2, Object object3, Object object4) {
        return clazz == FunctionCall.class && this.m_functionName.equals(object) && this.m_isDistinct == (Boolean)object2 && this.m_scalarValues.equals(object3) && FunctionCall.flatEquals(this.m_arguments, object4);
    }

    protected Object readResolve() {
        return FunctionCall.create(this.m_functionName, this.m_isDistinct, this.m_scalarValues, this.m_arguments);
    }

    static {
        s_operatorInfos.put(LOGICAL_OR, new OperatorInfo(OperatorType.NARY_INFIX, "||", 100));
        s_operatorInfos.put(LOGICAL_AND, new OperatorInfo(OperatorType.NARY_INFIX, "&&", 200));
        s_operatorInfos.put(LOGICAL_NOT, new OperatorInfo(OperatorType.UNARY, "!", 600));
        s_operatorInfos.put(EQUAL, new OperatorInfo(OperatorType.BINARY_INFIX, "=", 300));
        s_operatorInfos.put(NOT_EQUAL, new OperatorInfo(OperatorType.BINARY_INFIX, "!=", 300));
        s_operatorInfos.put(LESS_THAN, new OperatorInfo(OperatorType.BINARY_INFIX, "<", 300));
        s_operatorInfos.put(LESS_EQUAL_THAN, new OperatorInfo(OperatorType.BINARY_INFIX, "<=", 300));
        s_operatorInfos.put(GREATER_THAN, new OperatorInfo(OperatorType.BINARY_INFIX, ">", 300));
        s_operatorInfos.put(GREATER_EQUAL_THAN, new OperatorInfo(OperatorType.BINARY_INFIX, ">=", 300));
        s_operatorInfos.put(ADD, new OperatorInfo(OperatorType.NARY_INFIX, "+", 400));
        s_operatorInfos.put(SUBTRACT, new OperatorInfo(OperatorType.BINARY_INFIX, "-", 400));
        s_operatorInfos.put(MULTIPLY, new OperatorInfo(OperatorType.NARY_INFIX, "*", 500));
        s_operatorInfos.put(DIVIDE, new OperatorInfo(OperatorType.BINARY_INFIX, "/", 500));
        s_operatorInfos.put(IDIV, new OperatorInfo(OperatorType.BINARY_INFIX, "IDIV", 500));
        s_operatorInfos.put(MOD, new OperatorInfo(OperatorType.BINARY_INFIX, "MOD", 500));
        s_operatorInfos.put(NUMERIC_UNARY_PLUS, new OperatorInfo(OperatorType.UNARY, "+", 600));
        s_operatorInfos.put(NUMERIC_UNARY_MINUS, new OperatorInfo(OperatorType.UNARY, "-", 600));
        s_operatorInfos.put(IN, new OperatorInfo(OperatorType.IN_NOTIN, "IN", 1000));
        s_operatorInfos.put(NOT_IN, new OperatorInfo(OperatorType.IN_NOTIN, "NOT IN", 1000));
        s_classHashCodeTimes31 = 31 * FunctionCall.class.hashCode();
        s_creator = new InterningManager.Creator(){

            @Override
            public InterningManager.InternedObject create(Object object, Object object2, Object object3, Object object4) {
                return new FunctionCall((String)object, (Boolean)object2, (List)object3, (List)object4);
            }
        };
    }

    public static class ScalarValue
    extends ImmutablePair<String, String> {
        private static final long serialVersionUID = 6809795404206413759L;
        public static final ScalarValue[] EMPTY_ARRAY = new ScalarValue[0];

        public ScalarValue(String string, String string2) {
            super(string, string2);
        }
    }

    protected static class OperatorInfo {
        public final OperatorType m_operatorType;
        public final String m_text;
        public final int m_precedence;

        protected OperatorInfo(OperatorType operatorType, String string, int n) {
            this.m_operatorType = operatorType;
            this.m_text = string;
            this.m_precedence = n;
        }

        public boolean isArityCompatible(int n) {
            switch (this.m_operatorType) {
                case UNARY: {
                    return n == 1;
                }
                case BINARY_INFIX: {
                    return n == 2;
                }
                case NARY_INFIX: {
                    return n > 1;
                }
                case IN_NOTIN: {
                    return n >= 1;
                }
            }
            return false;
        }
    }

    protected static enum OperatorType {
        UNARY,
        BINARY_INFIX,
        NARY_INFIX,
        IN_NOTIN;

    }
}

