/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public final class ImmutableArrayList<E>
implements List<E>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = -5334598927423354483L;
    public final E[] m_elements;

    public ImmutableArrayList(E[] EArray) {
        this.m_elements = EArray;
    }

    public static <T> ImmutableArrayList<T> create(List<T> list, T[] TArray) {
        if (list instanceof ImmutableArrayList) {
            return (ImmutableArrayList)list;
        }
        return new ImmutableArrayList<T>(list.toArray(TArray));
    }

    @Override
    public int size() {
        return this.m_elements.length;
    }

    @Override
    public boolean isEmpty() {
        return this.m_elements.length == 0;
    }

    @Override
    public boolean contains(Object object) {
        int n = this.m_elements.length;
        for (int i = 0; i < n; ++i) {
            if (!this.m_elements[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableIterator<E>(this.m_elements, 0);
    }

    @Override
    public Object[] toArray() {
        int n = this.m_elements.length;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.m_elements, 0, objectArray, 0, n);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return ImmutableArrayList.toArray(this.m_elements, 0, this.m_elements.length, TArray);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public E get(int n) {
        return this.m_elements[n];
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public E remove(int n) {
        throw new UnsupportedOperationException("This array is immutable.");
    }

    @Override
    public int indexOf(Object object) {
        int n = this.m_elements.length;
        for (int i = 0; i < n; ++i) {
            if (!this.m_elements[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.m_elements.length - 1; i >= 0; --i) {
            if (!this.m_elements[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ImmutableIterator<E>(this.m_elements, 0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this.m_elements.length) {
            throw new IndexOutOfBoundsException();
        }
        return new ImmutableIterator<E>(this.m_elements, n);
    }

    @Override
    public List<E> subList(int n, int n2) {
        if (n < 0 || n2 > this.m_elements.length || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new ImmutableArraySublist<E>(this.m_elements, n, n2);
    }

    @Override
    public int hashCode() {
        return ImmutableArrayList.getHashCode(this.m_elements, 0, this.m_elements.length);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        return ImmutableArrayList.checkEquals(this.m_elements, 0, this.m_elements.length, (List)object);
    }

    protected static <T, U> T[] toArray(U[] UArray, int n, int n2, T[] TArray) {
        int n3 = TArray.length;
        if (n3 < n2) {
            Class<?> clazz = TArray.getClass();
            Object[] objectArray = clazz == Object[].class ? new Object[n2] : (Object[])Array.newInstance(clazz.getComponentType(), n2);
            System.arraycopy(UArray, n, objectArray, 0, n2);
            return objectArray;
        }
        System.arraycopy(UArray, n, TArray, 0, n2);
        if (n3 > n2) {
            TArray[n2] = null;
        }
        return TArray;
    }

    protected static <U> int getHashCode(U[] UArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = n3 * 31 + UArray[i].hashCode();
        }
        return n3;
    }

    protected static <U> boolean checkEquals(U[] UArray, int n, int n2, List<?> list) {
        int n3 = list.size();
        if (n3 != n2 - n) {
            return false;
        }
        if (list instanceof RandomAccess) {
            int n4 = n;
            for (int i = 0; i < n3; ++i) {
                if (UArray[n4++].equals(list.get(i))) continue;
                return false;
            }
        } else {
            int n5 = n;
            for (Object obj : list) {
                if (UArray[n5++].equals(obj)) continue;
                return false;
            }
        }
        return true;
    }

    protected static final class ImmutableIterator<U>
    implements ListIterator<U> {
        protected final U[] m_elements;
        protected int m_nextIndex;

        public ImmutableIterator(U[] UArray, int n) {
            this.m_elements = UArray;
            this.m_nextIndex = n;
        }

        @Override
        public boolean hasNext() {
            return this.m_nextIndex < this.m_elements.length;
        }

        @Override
        public U next() {
            try {
                return this.m_elements[this.m_nextIndex++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.m_nextIndex > 0;
        }

        @Override
        public U previous() {
            try {
                return this.m_elements[--this.m_nextIndex];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.m_nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.m_nextIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The underlying array is immutable.");
        }

        @Override
        public void set(U u) {
            throw new UnsupportedOperationException("The underlying array is immutable.");
        }

        @Override
        public void add(U u) {
            throw new UnsupportedOperationException("The underlying array is immutable.");
        }
    }

    protected static final class ImmutableArraySublist<E>
    implements List<E>,
    Serializable {
        private static final long serialVersionUID = -5959660208217488458L;
        protected final E[] m_elements;
        protected final int m_fromIndex;
        protected final int m_toIndex;

        public ImmutableArraySublist(E[] EArray, int n, int n2) {
            this.m_elements = EArray;
            this.m_fromIndex = n;
            this.m_toIndex = n2;
        }

        @Override
        public int size() {
            return this.m_toIndex - this.m_fromIndex;
        }

        @Override
        public boolean isEmpty() {
            return this.m_fromIndex >= this.m_toIndex;
        }

        @Override
        public boolean contains(Object object) {
            for (int i = this.m_fromIndex; i < this.m_toIndex; ++i) {
                if (!this.m_elements[i].equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new ImmutableSubiterator<E>(this.m_elements, this.m_fromIndex, this.m_toIndex, this.m_fromIndex);
        }

        @Override
        public Object[] toArray() {
            int n = this.m_toIndex - this.m_fromIndex;
            Object[] objectArray = new Object[n];
            System.arraycopy(this.m_elements, this.m_fromIndex, objectArray, 0, n);
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return ImmutableArrayList.toArray(this.m_elements, this.m_fromIndex, this.m_toIndex - this.m_fromIndex, TArray);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public E get(int n) {
            return this.m_elements[this.m_fromIndex + n];
        }

        @Override
        public E set(int n, E e) {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public void add(int n, E e) {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public E remove(int n) {
            throw new UnsupportedOperationException("This array is immutable.");
        }

        @Override
        public int indexOf(Object object) {
            for (int i = this.m_fromIndex; i < this.m_toIndex; ++i) {
                if (!this.m_elements[i].equals(object)) continue;
                return i - this.m_fromIndex;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            for (int i = this.m_toIndex - 1; i >= this.m_fromIndex; --i) {
                if (!this.m_elements[i].equals(object)) continue;
                return i - this.m_fromIndex;
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ImmutableSubiterator<E>(this.m_elements, this.m_fromIndex, this.m_toIndex, this.m_fromIndex);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            if (n < 0 || n > this.m_toIndex - this.m_fromIndex) {
                throw new IndexOutOfBoundsException();
            }
            return new ImmutableSubiterator<E>(this.m_elements, this.m_fromIndex, this.m_toIndex, this.m_fromIndex + n);
        }

        @Override
        public List<E> subList(int n, int n2) {
            if (n < 0 || n2 > this.m_toIndex - this.m_fromIndex || n > n2) {
                throw new IndexOutOfBoundsException();
            }
            return new ImmutableArraySublist<E>(this.m_elements, this.m_fromIndex + n, this.m_fromIndex + n2);
        }

        @Override
        public int hashCode() {
            return ImmutableArrayList.getHashCode(this.m_elements, this.m_fromIndex, this.m_toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof List)) {
                return false;
            }
            return ImmutableArrayList.checkEquals(this.m_elements, this.m_fromIndex, this.m_toIndex, (List)object);
        }

        protected static final class ImmutableSubiterator<U>
        implements ListIterator<U> {
            protected final U[] m_elements;
            protected final int m_fromIndex;
            protected final int m_toIndex;
            protected int m_nextIndex;

            public ImmutableSubiterator(U[] UArray, int n, int n2, int n3) {
                this.m_elements = UArray;
                this.m_fromIndex = n;
                this.m_toIndex = n2;
                this.m_nextIndex = n3;
            }

            @Override
            public boolean hasNext() {
                return this.m_nextIndex < this.m_toIndex;
            }

            @Override
            public U next() {
                if (this.m_nextIndex >= this.m_toIndex) {
                    throw new NoSuchElementException();
                }
                return this.m_elements[this.m_nextIndex++];
            }

            @Override
            public boolean hasPrevious() {
                return this.m_nextIndex > 0;
            }

            @Override
            public U previous() {
                if (this.m_nextIndex <= this.m_fromIndex) {
                    throw new NoSuchElementException();
                }
                return this.m_elements[--this.m_nextIndex];
            }

            @Override
            public int nextIndex() {
                return this.m_nextIndex;
            }

            @Override
            public int previousIndex() {
                return this.m_nextIndex - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The underlying array is immutable.");
            }

            @Override
            public void set(U u) {
                throw new UnsupportedOperationException("The underlying array is immutable.");
            }

            @Override
            public void add(U u) {
                throw new UnsupportedOperationException("The underlying array is immutable.");
            }
        }
    }
}

